<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'grl'], function () {
    Route::group(['prefix' => 'monedas'], function () {
        Route::post('list', 'GRL\MonedasController@list');
        Route::post('store', 'GRL\MonedasController@store');
    });

    Route::group(['prefix' => 'datos-ubigeos'], function () {
        Route::post('listDep', 'GRL\RegionesController@list');
        Route::post('listPro', 'GRL\ProvinciasController@list');
        Route::post('listDis', 'GRL\DistritosController@list');
    });

    Route::group(['prefix' => 'tipo_identificaciones'], function () {
        Route::post('list', 'GRL\TipoIdentificacionesController@list');
        Route::post('store', 'GRL\TipoIdentificacionesController@store');
    });

    Route::group(['prefix' => 'meses'], function () {
        Route::post('list', 'GRL\MesesController@list');
        Route::post('store', 'GRL\MesesController@store');
    });

    Route::group(['prefix' => 'empresas'], function () {
        Route::post('list', 'GRL\EmpresasController@list');
        Route::post('store', 'GRL\EmpresasController@store');
    });

    Route::group(['prefix' => 'personas'], function () {
        Route::post('list', 'GRL\PersonasController@list');
        Route::post('store', 'GRL\PersonasController@store');
    });
    
    Route::group(['prefix' => 'general'], function () {
        Route::post('subir-imagen', 'GRL\GeneralController@subirImagen');
        Route::post('subir-archivo', 'GRL\GeneralController@subirArchivo');
    });
    
    Route::group(['prefix' => 'general-personas'], function () {
        Route::post('list-all-personas', 'GRL\GeneralPersonasController@listAllPersonas');
    });
});
