<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'dgi'], function () {

    Route::group(['prefix' => 'padron'], function () {
        Route::post('list', 'DGI\PadronController@list');
        Route::post('store', 'DGI\PadronController@store');
        Route::post('list-import', 'DGI\PadronController@list_import');
        
        Route::post('import-siagie', 'DGI\PadronController@import_siagie');

        Route::post('import-excel', 'DGI\PadronController@import_excel');

        
    });

    Route::group(['prefix' => 'institucion-educativa'], function () {
        Route::post('list', 'DGI\InstitucionEducativaController@list');
        Route::post('store', 'DGI\InstitucionEducativaController@store');
        Route::post('import', 'DGI\InstitucionEducativaController@import');
    });
    
    Route::group(['prefix' => 'tipo-periodo'], function () {
        Route::post('list', 'DGI\TipoPeriodoController@list');
        Route::post('store', 'DGI\TipoPeriodoController@store');
    });

    Route::group(['prefix' => 'tipo-padron'], function () {
        Route::post('list', 'DGI\TipoPadronController@list');
        Route::post('store', 'DGI\TipoPadronController@store');
    });

    Route::group(['prefix' => 'anio-educativo'], function () {
        Route::post('list', 'DGI\AnioEducativoController@list');
        Route::post('store', 'DGI\AnioEducativoController@store');
    });

    Route::group(['prefix' => 'tipo-indice'], function () {
        Route::post('list', 'DGI\TipoIndiceController@list');
        Route::post('store', 'DGI\TipoIndiceController@store');
    });

    Route::group(['prefix' => 'tipo-indicador'], function () {
        Route::post('list', 'DGI\TipoIndicadorController@list');
        Route::post('store', 'DGI\TipoIndicadorController@store');
    });

    Route::group(['prefix' => 'tipo-atencion'], function () {
        Route::post('list', 'DGI\TipoAtencionController@list');
        Route::post('store', 'DGI\TipoAtencionController@store');
    });

    Route::group(['prefix' => 'modalidad-educativa'], function () {
        Route::post('list', 'DGI\ModalidadEducativaController@list');
        Route::post('store', 'DGI\ModalidadEducativaController@store');
    });

    Route::group(['prefix' => 'nivel-educativo'], function () {
        Route::post('list', 'DGI\NivelEducativoController@list');
        Route::post('store', 'DGI\NivelEducativoController@store');
    });

    Route::group(['prefix' => 'modalidad-nivel'], function () {
        Route::post('list', 'DGI\ModalidadNivelController@list');
        Route::post('store', 'DGI\ModalidadNivelController@store');
    });

    Route::group(['prefix' => 'grado-educativo'], function () {
        Route::post('list', 'DGI\GradoEducativoController@list');
        Route::post('store', 'DGI\GradoEducativoController@store');
    });

    Route::group(['prefix' => 'seccion-educativa'], function () {
        Route::post('list', 'DGI\SeccionEducativaController@list');
        Route::post('store', 'DGI\SeccionEducativaController@store');
    });

    Route::group(['prefix' => 'ubigeos'], function () {
        Route::post('list', 'DGI\UbigeosController@list');
        Route::post('store', 'DGI\UbigeosController@store');
    });

    Route::group(['prefix' => 'padron-vacante-config'], function () {
        Route::post('list', 'DGI\PadronVacanteConfiguracionController@list');
        Route::post('store', 'DGI\PadronVacanteConfiguracionController@store');
    });    

    Route::group(['prefix' => 'padron-vacante'], function () {
        Route::post('list', 'DGI\PadronVacanteController@list');
        Route::post('store', 'DGI\PadronVacanteController@store');
        Route::post('import', 'DGI\PadronVacanteController@import');
    });

    Route::group(['prefix' => 'detalle-vacante'], function () {
        Route::post('list', 'DGI\DetalleVacanteController@list');
        Route::post('store', 'DGI\DetalleVacanteController@store');
        Route::post('import', 'DGI\DetalleVacanteController@import');
    });

    Route::group(['prefix' => 'padron-indicador'], function () {
        Route::post('list', 'DGI\PadronIndicadorController@list');
        Route::post('store', 'DGI\PadronIndicadorController@store');
        Route::post('import', 'DGI\PadronIndicadorController@import');
    });

    Route::group(['prefix' => 'detalle-indicador'], function () {
        Route::post('list', 'DGI\DetalleIndicadorController@list');
        Route::post('store', 'DGI\DetalleIndicadorController@store');
        Route::post('import', 'DGI\DetalleIndicadorController@import');
    });

    Route::group(['prefix' => 'personas-institucion-educativa'], function () {
        Route::post('list', 'DGI\PersonasInstitucionEducativaController@list');
        Route::post('store', 'DGI\PersonasInstitucionEducativaController@store');
    });

    Route::group(['prefix' => 'personas-ugel'], function () {
        Route::post('list', 'DGI\PersonasUgelController@list');
        Route::post('store', 'DGI\PersonasUgelController@store');
    });

    Route::group(['prefix' => 'configuracion-vacante'], function () {
        Route::post('list', 'DGI\ConfiguracionVacanteController@list');
        Route::post('store', 'DGI\ConfiguracionVacanteController@store');
    });

});
