<?php

namespace App\Http\Controllers\SEG;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class MenuLateralController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iMenuLateId   ?? NULL,
            $request->iSistId       ?? NULL,
            $request->name          ?? NULL,
            $request->type          ?? NULL,
            $request->icon          ?? NULL,
            $request->link          ?? NULL,
            $request->color         ?? NULL,

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->iCredId

        ];

        try {
            $data = DB::select('exec SEG.Sp_SEG_CRUD_MENU_LATERAL
            ?,?,?,?,?,?,?,?,?,?,?,?', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'message' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

   
}
