<?php

namespace App\Http\Controllers\SEG;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;


class CredencialesController extends Controller
{
    public function store(Request $request)
    {
        
        $parametros = [
            $request->opcion,
            $request->valorBusqueda         ?? '',

            $request->iCredId,
            $request->iPersId               ?? NULL,
            $request->iTipoCredId           ?? NULL,
            $request->cCredUsuario          ?? NULL,

            $request->password              ?? NULL,

            $request->iCredIntentos         ?? NULL,
            $request->dtCredRegistro        ?? NULL,
            $request->dtCredUltimaSesion    ?? NULL,
            
            $request->cCredToken            ?? NULL,
            $request->cCredKey              ?? NULL,
           

            $request->iEstado ?? 1,
            $request->bHabilitado ?? 1,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->server->get('REMOTE_ADDR')

        ];
        
        try {
            
            $data = DB::select('exec [SEG].[Sp_SEG_CRUD_CREDENCIALES] ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);
           //return $data;
            if ($data[0]->iCredId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                $codeResponse = 200;
            } else {
                $response = ['validated' => true, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {

            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'exception' => $e];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }
}
