<?php

namespace App\Http\Controllers\GRL;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TipoPersonasController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iTipoPersId            ?? null,
            //$request->iSistId				?? null,
            $request->cSistCode                ?? null,
            $request->cTipoPersCode            ?? null,
            $request->cTipoPersNombre        ?? null,
            $request->cTipoPersDescripcion  ?? null,
            $request->cTipoPersAbrev        ?? null,

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('exec GRL.Sp_GRL_CRUD_TIPO_PERSONAS
            ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'message' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iTipoPersId            ?? null,
            //$request->iSistId				?? null,
            $request->cSistCode                ?? null,
            $request->cTipoPersCode            ?? null,
            $request->cTipoPersNombre        ?? null,
            $request->cTipoPersDescripcion  ?? null,
            $request->cTipoPersAbrev        ?? null,

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId


        ];

        try {
            $data = DB::select('exec GRL.Sp_GRL_CRUD_TIPO_PERSONAS
            ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);

            if ($data[0]->iTipoPersId > 0) {

                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
                $codeResponse = 200;
            } else {
                $response = ['validated' => true, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {

            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'exception' => $e];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function search($data)
    {

        $parametros = [
            $data['opcion'] ?? NULL,
            $data['valorBusqueda'] ?? '-',

            $data['iTipoPersId'] ?? null,
            //$data['iSistId'] ?? null,
            $data['cSistCode'] ?? null,
            $data['cTipoPersCode'] ?? null,
            $data['cTipoPersNombre'] ?? null,
            $data['cTipoPersDescripcion']  ?? null,
            $data['cTipoPersAbrev']        ?? null,

            $data['iEstado'] ?? 1,
            $data['bHabilitado'] ?? true,

            $data['cEquipoSis'] ?? 'equipo',
            $data['cOpenUsr'] ?? 'N',
            $data['cMacNicSis'] ?? 'mac',
            '-',

            $data['iCredId'] ?? NULL

        ];
        //return $parametros;

        $data = DB::select('exec GRL.Sp_GRL_CRUD_TIPO_PERSONAS
            ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);

        return $data;
    }
}
