<?php

namespace App\Http\Controllers\GRL;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class GeneralController extends Controller
{
    public function subirImagen(Request $request)
    {
        
        $this->validate(
            $request,
            [
                'file' => 'required|mimes:pdf,jpeg,png'
            ],
            [
                'file.required' => 'Es necesario que cargue un archivo',
                'file.mimes' => 'El archivo debe ser formato PDF, JPEG o PNG; seleccione otro archivo.',
            ]
        );

        if ($request->hasFile('file')) {

            $file = $request->file('file');
            $carpeta =  $request['carpeta'];

            if (!is_dir($carpeta)) {
                //SI NO EXISTE CARPETA, LO CREA
                mkdir($request->carpeta, 0777, true);
            }

            $path = $file->store($carpeta, ['disk' => 'file']);

            return response()->json($path);
        } else {
            abort(503, 'No se adjuntaron archivos');
        }
    }

    public function subirArchivo(Request $request)
    {
        
        $this->validate(
            $request,
            [
                'file' => 'required|mimes:pdf,jpeg,png,xlsx,xls'
            ],
            [
                'file.required' => 'Es necesario que cargue un archivo',
                'file.mimes' => 'El archivo debe ser formato PDF, JPEG o PNG; seleccione otro archivo.',
            ]
        );

        if ($request->hasFile('file')) {

            $file = $request->file('file');
            $carpeta =  $request['carpeta'];

            // if (!is_dir($carpeta)) {
            //     //SI NO EXISTE CARPETA, LO CREA
            //     mkdir($request->carpeta, 0777, true);
            // }

            $path = $file->store($carpeta, ['disk' => 'file']);

            return response()->json($path);
        } else {
            abort(503, 'No se adjuntaron archivos');
        }
    }
}
