<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class UbigeosController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iUbigeoId                ?? NULL,
            $request->cUbigeoReniec            ?? NULL,
            $request->cUbigeoInei            ?? NULL,
            $request->cUbigeoDepartamento    ?? NULL,
            $request->cUbigeoProvincia        ?? NULL,
            $request->cUbigeoDistrito        ?? NULL,

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('call Sp_DGI_CRUD_UBIGEOS_MOQUE
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'message' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {
    }

    public function import(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId,

            json_encode($request->json_instituciones)
        ];

        try {
            $data = DB::select('call Sp_EDU_IMPORT_UBIGEOS_MOQUE (?,?,?,?,?,?)', $parametros);

            $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
            $codeResponse = 200;
        } catch (\Exception $e) {

            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'exception' => $e];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }
}
