<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TipoPeriodoController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iTipoPeriId            ?? null,
            $request->cTipoPeriNombre        ?? null,
            $request->cTipoPeriDescripcion  ?? null,
            $request->cTipoPeriAbreviatura        ?? null,

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('call Sp_DGI_CRUD_TIPO_PERIODO
            (?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function search($data)
    {

        $parametros = [
            $data['opcion'] ?? NULL,
            $data['valorBusqueda'] ?? '-',

            $data['iTipoPeriId'] ?? NULL,
            $data['cTipoPeriNombre'] ?? NULL,
            $data['cTipoPeriDescripcion'] ?? NULL,
            $data['cTipoPeriAbreviatura'] ?? NULL,

            $data['iEstado'] ?? 1,
            $data['bHabilitado'] ?? true,

            $data['cEquipoSis'] ?? 'equipo',
            $data['cOpenUsr'] ?? 'N',
            $data['cMacNicSis'] ?? 'mac',
            '-',

            $data['iCredId'] ?? NULL

        ];


        $data = DB::select('call Sp_DGI_CRUD_TIPO_PERIODO
        (?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);


        return $data;
    }
}
