<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TipoIndiceController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iTipoIndiId            ?? null,
            $request->iAniEducdId            ?? null,
            $request->iModaNiveId            ?? null,
            $request->cTipoIndiNombre        ?? null,
            $request->nTipoIndiValor        ?? null,
            $request->cTipoIndiDescripcion  ?? null,
            $request->cTipoIndiAbreviatura        ?? null,

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('call Sp_DGI_CRUD_TIPO_INDICE
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            $response = ['validated' => true, 'mensaje' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '',

            $request->iTipoIndiId            ?? null,
            $request->iAniEducdId            ?? null,
            $request->iModaNiveId            ?? null,
            $request->cTipoIndiNombre        ?? null,
            $request->nTipoIndiValor        ?? null,
            $request->cTipoIndiDescripcion  ?? null,
            $request->cTipoIndiAbreviatura        ?? null,

            $request->iEstado       ?? 1,
            $request->bHabilitado   ?? 1,

            $request->cEquipoSis    ?? 'equipo',
            $request->ip(),
            $request->cOpenUsr      ?? 'N',
            $request->cMacNicSis    ?? 'mac',

            $request->iCredId

        ];

        try {

            $data = DB::select('call Sp_DGI_CRUD_TIPO_INDICE
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);

            if ($data[0]->iTipoIndiId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                $codeResponse = 200;
            } else {
                $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    // public function search($data)
    // {

    //     $parametros = [
    //         $data['opcion'] ?? NULL,
    //         $data['valorBusqueda'] ?? '-',

    //         $data['iTipoIndiId'] ?? NULL,
    //         $data['cTipoIndiNombre'] ?? NULL,
    //         $data['nTipoIndiValor'] ?? NULL,
    //         $data['cTipoIndiDescripcion'] ?? NULL,
    //         $data['cTipoIndiAbreviatura'] ?? NULL,

    //         $data['iEstado'] ?? 1,
    //         $data['bHabilitado'] ?? true,

    //         $data['cEquipoSis'] ?? 'equipo',
    //         $data['cOpenUsr'] ?? 'N',
    //         $data['cMacNicSis'] ?? 'mac',
    //         '-',

    //         $data['iCredId'] ?? NULL

    //     ];


    //     $data = DB::select('call Sp_DGI_CRUD_TIPO_INDICE
    //     ?,?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);


    //     return $data;
    // }
}
