<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SeccionEducativaController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iSeccEducId            ?? null,
            $request->cSeccEducCode        ?? null,
            $request->cSeccEducNombre        ?? null,
            $request->cSeccEducDescripcion  ?? null,
            $request->cSeccEducAbreviatura  ?? null,

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('CALL Sp_DGI_CRUD_SECCION_EDUCATIVA
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            $response = ['validated' => true, 'mensaje' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '',

            $request->iSeccEducId            ?? null,
            $request->cSeccEducCode        ?? null,
            $request->cSeccEducNombre        ?? null,
            $request->cSeccEducDescripcion  ?? null,
            $request->cSeccEducAbreviatura  ?? null,

            $request->iEstado       ?? 1,
            $request->bHabilitado   ?? 1,

            $request->cEquipoSis    ?? 'equipo',
            $request->ip(),
            $request->cOpenUsr      ?? 'N',
            $request->cMacNicSis    ?? 'mac',

            $request->iCredId

        ];

        try {

            $data = DB::select('CALL Sp_DGI_CRUD_SECCION_EDUCATIVA
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);

            if ($data[0]->iSeccEducId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                $codeResponse = 200;
            } else {
                $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function search($data)
    {

        $parametros = [
            $data['opcion'] ?? NULL,
            $data['valorBusqueda'] ?? '-',

            $data['iSeccEducId'] ?? NULL,
            $data['cSeccEducCode'] ?? NULL,
            $data['cSeccEducNombre'] ?? NULL,
            $data['cSeccEducDescripcion'] ?? NULL,
            $data['cSeccEducAbreviatura'] ?? NULL,

            $data['iEstado'] ?? 1,
            $data['bHabilitado'] ?? true,

            $data['cEquipoSis'] ?? 'equipo',
            $data['cOpenUsr'] ?? 'N',
            $data['cMacNicSis'] ?? 'mac',
            '-',

            $data['iCredId'] ?? NULL

        ];


        $data = DB::select('CALL Sp_DGI_CRUD_SECCION_EDUCATIVA
        (?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);


        return $data;
    }
}
