<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class PadronWebController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iPadrWebId                ?? NULL,
            $request->iPadrId                    ?? NULL,
            $request->cPadrWebCOD_MOD            ?? NULL,
            $request->cPadrWebANEXO           ?? NULL,
            $request->cPadrWebCODLOCAL        ?? NULL,
            $request->cPadrWebCEN_EDU         ??  NULL,
            $request->cPadrWebNIV_MOD         ?? NULL,
            $request->cPadrWebD_NIV_MOD       ?? NULL,
            $request->cPadrWebD_FORMA         ?? NULL,
            $request->cPadrWebCOD_CAR         ?? NULL,
            $request->cPadrWebD_COD_CAR       ?? NULL,
            $request->cPadrWebTIPSSEXO        ?? NULL,
            $request->cPadrWebD_TIPSSEXO      ?? NULL,
            $request->cPadrWebGESTION         ?? NULL,
            $request->cPadrWebD_GESTION       ?? NULL,
            $request->cPadrWebGES_DEP         ?? NULL,
            $request->cPadrWebD_GES_DEP       ?? NULL,
            $request->cPadrWebDIRECTOR        ?? NULL,
            $request->cPadrWebTELEFONO        ?? NULL,
            $request->cPadrWebEMAIL           ?? NULL,
            $request->cPadrWebPAGWEB          ?? NULL,
            $request->cPadrWebDIR_CEN         ?? NULL,
            $request->cPadrWebREFERENCIA      ?? NULL,
            $request->cPadrWebLOCALIDAD       ?? NULL,
            $request->cPadrWebCODCP_INEI      ?? NULL,
            $request->cPadrWebCODCCPP         ?? NULL,
            $request->cPadrWebCEN_POB         ?? NULL,
            $request->cPadrWebAREA_CENSO      ?? NULL,
            $request->cPadrWebDAREACENSO      ?? NULL,
            $request->cPadrWebCODGEO          ?? NULL,
            $request->cPadrWebD_DPTO          ?? NULL,
            $request->cPadrWebD_PROV          ?? NULL,
            $request->cPadrWebD_DIST          ?? NULL,
            $request->cPadrWebD_REGION        ?? NULL,
            $request->cPadrWebCODOOII         ?? NULL,
            $request->cPadrWebD_DREUGEL       ?? NULL,
            $request->cPadrWebNLAT_IE         ?? NULL,
            $request->cPadrWebNLONG_IE        ?? NULL,
            $request->cPadrWebTIPOPROG        ?? NULL,
            $request->cPadrWebD_TIPOPROG      ?? NULL,
            $request->cPadrWebCOD_TUR         ?? NULL,
            $request->cPadrWebD_COD_TUR       ?? NULL,
            $request->cPadrWebESTADO          ?? NULL,
            $request->cPadrWebD_ESTADO        ?? NULL,
            $request->cPadrWebD_FTE_DATO      ?? NULL,
            $request->cPadrWebTALUM_HOM       ?? NULL,
            $request->cPadrWebTALUM_MUJ       ?? NULL,
            $request->cPadrWebTALUMNO         ?? NULL,
            $request->cPadrWebTDOCENTE        ?? NULL,
            $request->cPadrWebTSECCION        ?? NULL,
            $request->cPadrWebFECHAREG        ?? NULL,
            $request->cPadrWebFECHA_ACT       ?? NULL,//54

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('exec DGI.Sp_DGI_CRUD_PADRON_WEB
            ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '',

            $request->iPadrWebId              ?? NULL,
            $request->iPadrId                 ?? NULL,
            $request->cPadrWebCOD_MOD         ?? NULL,
            $request->cPadrWebANEXO           ?? NULL,
            $request->cPadrWebCODLOCAL        ?? NULL,
            $request->cPadrWebCEN_EDU         ??  NULL,
            $request->cPadrWebNIV_MOD         ?? NULL,
            $request->cPadrWebD_NIV_MOD       ?? NULL,
            $request->cPadrWebD_FORMA         ?? NULL,
            $request->cPadrWebCOD_CAR         ?? NULL,
            $request->cPadrWebD_COD_CAR       ?? NULL,
            $request->cPadrWebTIPSSEXO        ?? NULL,
            $request->cPadrWebD_TIPSSEXO      ?? NULL,
            $request->cPadrWebGESTION         ?? NULL,
            $request->cPadrWebD_GESTION       ?? NULL,
            $request->cPadrWebGES_DEP         ?? NULL,
            $request->cPadrWebD_GES_DEP       ?? NULL,
            $request->cPadrWebDIRECTOR        ?? NULL,
            $request->cPadrWebTELEFONO        ?? NULL,
            $request->cPadrWebEMAIL           ?? NULL,
            $request->cPadrWebPAGWEB          ?? NULL,
            $request->cPadrWebDIR_CEN         ?? NULL,
            $request->cPadrWebREFERENCIA      ?? NULL,
            $request->cPadrWebLOCALIDAD       ?? NULL,
            $request->cPadrWebCODCP_INEI      ?? NULL,
            $request->cPadrWebCODCCPP         ?? NULL,
            $request->cPadrWebCEN_POB         ?? NULL,
            $request->cPadrWebAREA_CENSO      ?? NULL,
            $request->cPadrWebDAREACENSO      ?? NULL,
            $request->cPadrWebCODGEO          ?? NULL,
            $request->cPadrWebD_DPTO          ?? NULL,
            $request->cPadrWebD_PROV          ?? NULL,
            $request->cPadrWebD_DIST          ?? NULL,
            $request->cPadrWebD_REGION        ?? NULL,
            $request->cPadrWebCODOOII         ?? NULL,
            $request->cPadrWebD_DREUGEL       ?? NULL,
            $request->cPadrWebNLAT_IE         ?? NULL,
            $request->cPadrWebNLONG_IE        ?? NULL,
            $request->cPadrWebTIPOPROG        ?? NULL,
            $request->cPadrWebD_TIPOPROG      ?? NULL,
            $request->cPadrWebCOD_TUR         ?? NULL,
            $request->cPadrWebD_COD_TUR       ?? NULL,
            $request->cPadrWebESTADO          ?? NULL,
            $request->cPadrWebD_ESTADO        ?? NULL,
            $request->cPadrWebD_FTE_DATO      ?? NULL,
            $request->cPadrWebTALUM_HOM       ?? NULL,
            $request->cPadrWebTALUM_MUJ       ?? NULL,
            $request->cPadrWebTALUMNO         ?? NULL,
            $request->cPadrWebTDOCENTE        ?? NULL,
            $request->cPadrWebTSECCION        ?? NULL,
            $request->cPadrWebFECHAREG        ?? NULL,
            $request->cPadrWebFECHA_ACT       ?? NULL,//54

            $request->iEstado       ?? 1,
            $request->bHabilitado   ?? 1,

            $request->cEquipoSis    ?? 'equipo', 
            $request->ip(),
            $request->cOpenUsr      ?? 'N',
            $request->cMacNicSis    ?? 'mac',//60

            $request->iCredId //61
        ];

        try {

            $data = DB::select('exec DGI.Sp_DGI_CRUD_PADRON_WEB
            ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);

            if ($data[0]->iPadrWebId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                $codeResponse = 200;
            } else {
                $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function import(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId,

            json_encode($request->json_padron_web)
        ];

        try {
            $data = DB::select('exec DGI.Sp_DGI_IMPORT_PADRON_WEB ?,?,?,?,?,?', $parametros);

            $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
            $codeResponse = 200;
        } catch (\Exception $e) {

            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'exception' => $e];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }
}
