<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;



class DetalleVacanteController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [

            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iPadrVacaDetaId                       ?? NULL,
            $request->iPadrVacaId                           ?? NULL,
            // $request->iNiveEducId                           ?? NULL,
            $request->iGradEducId                           ?? NULL,
            $request->iSeccEducId                           ?? NULL,

            $request->iPadrVacaDetaEstuPromovidosRegulares    ?? NULL,
            $request->iPadrVacaDetaEstuPromovidosNNEE        ?? NULL,
            $request->iPadrVacaDetaTotalEstuPromovidos        ?? NULL,
            $request->iPadrVacaDetaVacaDeclarar                ?? NULL,
            $request->iPadrVacaDetaVacaDeclarar_NNEE        ?? NULL,
            $request->iPadrVacaDetaTotal_Vacante            ?? NULL,



            $request->iEstado ?? 1,
            $request->bHabilitado ?? true, //20

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('CALL Sp_DGI_CRUD_PADRON_VACANTE_DETALLE
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'message' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '',

            $request->iPadrVacaDetaId                       ?? NULL,
            $request->iPadrVacaId                           ?? NULL,
            // $request->iNiveEducId                           ?? NULL,
            $request->iGradEducId                           ?? NULL,
            $request->iSeccEducId                           ?? NULL,

            $request->iPadrVacaDetaEstuPromovidosRegulares    ?? NULL,
            $request->iPadrVacaDetaEstuPromovidosNNEE        ?? NULL,
            $request->iPadrVacaDetaTotalEstuPromovidos        ?? NULL,
            $request->iPadrVacaDetaVacaDeclarar                ?? NULL,
            $request->iPadrVacaDetaVacaDeclarar_NNEE        ?? NULL,
            $request->iPadrVacaDetaTotal_Vacante            ?? NULL,


            $request->iEstado       ?? 1,
            $request->bHabilitado   ?? 1,

            $request->cEquipoSis    ?? 'equipo',
            $request->ip(),
            $request->cOpenUsr      ?? 'N',
            $request->cMacNicSis    ?? 'mac',

            $request->iCredId //31

        ];

        try {

            $data = DB::select('CALL Sp_DGI_CRUD_PADRON_VACANTE_DETALLE
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);

            if ($data[0]->iPadrVacaDetaId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                $codeResponse = 200;
            } else {
                $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }
}
