<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject

{
    use  Notifiable;
    
    protected $table = 'CREDENCIALES';
    protected $primaryKey = 'iCredId';
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password', 'cCredUsuario', 'iTipoCredId', 'iPersId',
        'dtCredRegistro', 'dtCredUltimaSesion', 'cCredToken', 'iCredIntentos',
        'iCredEstado', 'cCredKey', 'cCredRol', 'cCredUsuarioSis',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
        'dtCredFechaSis', 'cCredEquipoSis', 'cCredIpSis',
        'cCredOpenUsr', 'cCredMacNicSis',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getJWTIdentifier() {
        return $this->getKey();
    }

    public function getJWTCustomClaims() {
        return [];
    
    }
    

   


}
