<?php

namespace App\Http\Controllers\SEG;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\GRL\PersonasController;
use App\Http\Controllers\GRL\PersonaTipoContactoController;

class UsuariosController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            //$request->iCredId          ?? null,
            $request->iPersId          ?? null,
            $request->cCredUsuario 	   ?? NULL,     

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('exec SEG.Sp_SEG_CRUD_USUARIOS
            ?,?,?,?,?,?,?,?,?,?,?', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'message' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );
        if ($request->opcion == 'GUARDAR') {
            $persona = new PersonasController();
            $response_persona = $persona->store($request);

            $request->iPersId = $response_persona['data'][0]->iPersId;

            $persona_tipo_contacto = new PersonaTipoContactoController();
            $response_persona_tipo_contacto = $persona_tipo_contacto->store($request);

            //return $response_persona['data'][0]->iPersId;
            //return $response_persona_tipo_contacto;
        }

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            //$request->iCredId          ?? null,
            $request->iPersId          ?? null,
            $request->cCredUsuario 	   ?? NULL,       


            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId


        ];
        
        try {
            $data = DB::select('exec SEG.Sp_SEG_CRUD_USUARIOS
            ?,?,?,?,?,?,?,?,?,?,?', $parametros);

            if ($data[0]->iCredId > 0) {

                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
                $codeResponse = 200;
            } else {
                $response = ['validated' => true, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {

            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'exception' => $e];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    // public function import(Request $request)
    // {
    //     $this->validate(
    //         $request,
    //         [
    //             'opcion' => 'required',
    //         ],
    //         [
    //             'opcion.required' => 'Hubo un problema al obtener la acción',
    //         ]
    //     );

    //     $parametros = [
    //         $request->cEquipoSis ?? 'equipo',
    //         $request->cOpenUsr ?? 'N',
    //         $request->cMacNicSis ?? 'mac',
    //         $request->ip(),

    //         $request->iCredId,

    //         json_encode($request->json_usuarios)
    //     ];
        
    //     try {
    //         $data = DB::select('exec EDU.Sp_EDU_IMPORT_DOCENTES ?,?,?,?,?,?', $parametros);
                
    //             $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
    //             $codeResponse = 200;
           
    //     } catch (\Exception $e) {

    //         $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'exception' => $e];
    //         $codeResponse = 500;
    //     }

    //     return response()->json($response, $codeResponse);
    // }
}
