<?php

namespace App\Http\Controllers\GRL;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class UbigeosController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iUbigeoId               ?? null,
            $request->cUbigeoId               ?? null,
            $request->cUbigeoDepartamento     ?? null,
            $request->cUbigeoProvincia        ?? null,
            $request->cUbigeoDistrito         ?? null,

            $request->bHabilitado             ?? null,

            $request->cEquipoSis              ?? 'equipo',
            $request->ip(),
            $request->cOpenUsr                ?? 'N',
            $request->cMacNicSis              ?? 'mac',

            $request->iCredId

        ];

        try {
            $data = DB::select('exec GRL.Sp_GRL_CRUD_UBIGEOS
            ?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'message' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iUbigeoId               ?? null,
            $request->cUbigeoId               ?? null,
            $request->cUbigeoDepartamento     ?? null,
            $request->cUbigeoProvincia        ?? null,
            $request->cUbigeoDistrito         ?? null,

            $request->bHabilitado             ?? null,

            $request->cEquipoSis              ?? 'equipo',
            $request->ip(),
            $request->cOpenUsr                ?? 'N',
            $request->cMacNicSis              ?? 'mac',

            $request->iCredId


        ];

        try {
            $data = DB::select('exec GRL.Sp_GRL_CRUD_UBIGEOS
            ?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);

            if ($data[0]->iTipoIdenId > 0) {

                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
                $codeResponse = 200;
            } else {
                $response = ['validated' => true, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {

            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'exception' => $e];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function search($data)
    {

        $parametros = [
            $data['opcion'] ?? NULL,
            $data['valorBusqueda'] ?? '-',

            $data['iUbigeoId']               ?? null,
            $data['cUbigeoId']               ?? null,
            $data['cUbigeoDepartamento']     ?? null,
            $data['cUbigeoProvincia']        ?? null,
            $data['cUbigeoDistrito']         ?? null,

            $data['bHabilitado']             ?? null,

            $data['cEquipoSis']              ?? 'equipo',
            '-',
            $data['cOpenUsr']                ?? 'N',
            $data['cMacNicSis']              ?? 'mac',


            $data['iCredId'] ?? NULL

        ];
        //return $parametros;

        $data = DB::select('exec GRL.Sp_GRL_CRUD_UBIGEOS
        ?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);

        return $data;
    }
}
