<?php

namespace App\Http\Controllers\GRL;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;


class PersonasController extends Controller
{

    public function list(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '',

            $request->iPersId ?? NULL,
            $request->iTipoPersId ?? NULL,
            $request->iTipoIdenId ?? NULL,

            $request->iTipoEstaCiviId ?? NULL,
            $request->iTipoSexoId     ?? NULL,

            $request->iPaisId ?? NULL,
            $request->iRegiId ?? NULL,
            $request->iPrvnId ?? NULL,
            $request->iDsttId ?? NULL,

            $request->cPersDocumento ?? NULL,
            $request->cPersPaterno ?? NULL,
            $request->cPersMaterno ?? NULL,
            $request->cPersNombre ?? NULL,

            $request->dPersNacimiento ?? NULL,
            $request->cPersFotografia ?? NULL,
            $request->cPersDomicilio  ?? NULL,

            $request->cPersDireccion ?? NULL,
            $request->cPersTelefono ?? NULL,
            $request->cPersCorreo ?? NULL,

            $request->iEstado ?? 1,
            $request->bHabilitado ?? 1,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->server->get('REMOTE_ADDR'),

            $request->iCredId,

            $request->cTipoCode  ?? NULL,
            $request->iAccesoVacante ?? NULL,
            $request->iAccesoMatricula ?? NULL,


            //$request->iAcceso ?? NULL,
            //$request->iTipoAcceso ?? NULL,

            //$request->modulo ?? NULL,

        ];

        try {

            $data = DB::select('CALL Sp_GRL_CRUD_PERSONAS(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'message' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '',

            $request->iPersId ?? NULL,
            $request->iTipoPersId ?? NULL,
            $request->iTipoIdenId ?? NULL,
            
            $request->iTipoEstaCiviId ?? NULL,
            $request->iTipoSexoId     ?? NULL,

            $request->iPaisId ?? NULL,
            $request->iRegiId ?? NULL,
            $request->iPrvnId ?? NULL,
            $request->iDsttId ?? NULL,

            $request->cPersDocumento ?? NULL,
            $request->cPersPaterno ?? NULL,
            $request->cPersMaterno ?? NULL,
            $request->cPersNombre ?? NULL,

            $request->dPersNacimiento ?? NULL,
            $request->cPersFotografia ?? NULL,
            $request->cPersDomicilio  ?? NULL,

            $request->cPersDireccion ?? NULL,
            $request->cPersTelefono ?? NULL,
            $request->cPersCorreo ?? NULL,

            $request->iEstado ?? 1,
            $request->iHabilitado ?? 1,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->server->get('REMOTE_ADDR'),

            $request->iCredId,

            $request->cTipoCode  ?? NULL,
            $request->iAccesoVacante ?? NULL,
            $request->iAccesoMatricula ?? NULL,

        ];

        try {
            //return $parametros;
            $data = DB::select('CALL Sp_GRL_CRUD_PERSONAS(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            
            //return $data;
            if ($data[0]->iPersId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                //$codeResponse = 200;
            } else {
                $response = ['validated' => true, 'mensaje' => 'No se ha podido guardar la información.'];
                //$codeResponse = 500;
            }
        } catch (\Exception $e) {

            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'exception' => $e];
            //$codeResponse = 500;
        }

        return $response;
        // return Response::json([
        //     'response' => $response,
        //     'codeResponse' => $codeResponse

        // ]);
    }
}
