<?php

namespace App\Http\Controllers\GRL;


use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;


class PersonaTipoContactoController extends Controller
{

    public function store(Request $request)
    {
        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '',

            $request->iPersTipoContId ?? NULL,
            $request->iPersId ?? NULL,
            
            $request->cPersDireccion ?? NULL,
            $request->cPersCorreo ?? NULL,
            $request->cPersTelefono ?? NULL,

            $request->iEstado ?? 1,
            $request->iHabilitado ?? 1,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->server->get('REMOTE_ADDR'),

            $request->iCredId,

        ];

        try {

            $data = DB::select('exec [GRL].[Sp_GRL_CRUD_PERSONA_TIPO_CONTACTO] ?,?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);
            if ($data[0]->iPersTipoContId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                //$codeResponse = 200;
            } else {
                $response = ['validated' => true, 'mensaje' => 'No se ha podido guardar la información.'];
                //$codeResponse = 500;
            }
        } catch (\Exception $e) {

            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'exception' => $e];
            //$codeResponse = 500;
        }

        return $response;
        // return Response::json([
        //     'response' => $response,
        //     'codeResponse' => $codeResponse

        // ]);
    }
}
