<?php

namespace App\Http\Controllers\EDU;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\GRL\PersonasController;
use App\Http\Controllers\GRL\PersonaTipoContactoController;

class InstitucionesController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iInstEducId               ?? NULL,
            $request->iGereId                   ?? NULL,
            $request->iUgelId                   ?? NULL,
            $request->iAreaGeogEducId           ?? NULL,
            $request->iCaraEducId               ?? NULL,
            $request->iGeneEducId               ?? NULL,
            $request->iTurnEducId               ?? NULL,
            $request->iModaNiveId               ?? NULL,
            $request->iDoceId                   ?? NULL,
            $request->iInstEducCodigoLocal      ?? NULL,
            $request->iInstEducCodigoModular    ?? NULL,
            $request->cInstEducNombre           ?? NULL,
            $request->cInstEducDescripcion      ?? NULL,
            $request->cInstEducDependencia      ?? NULL,
            $request->cInstEducRuc              ?? NULL,
            $request->cInstEducDireccion        ?? NULL,
            $request->cInstEducUbigeo           ?? NULL,
            $request->iInstEducCantDoce         ?? NULL,
            $request->iInstEducCantEstu         ?? NULL,
            $request->iInstEducCantSeccion      ?? NULL,


            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('exec EDU.Sp_EDU_CRUD_INSTITUCIONES
            ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'message' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {

    }

    public function import(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId,

            json_encode($request->json_instituciones)
        ];
        
        try {
            $data = DB::select('exec EDU.Sp_EDU_IMPORT_INSTITUCIONES ?,?,?,?,?,?', $parametros);
                
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
                $codeResponse = 200;
           
        } catch (\Exception $e) {

            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'exception' => $e];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }
}
