<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PersonasInstitucionEducativaController extends Controller
{

    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iPersInstEducId            ?? null,
            $request->iPersId        ?? null,
            $request->iInstEducId  ?? null,

            // $request->iEstado ?? 1,
            // $request->bHabilitado ?? true,

            // $request->cEquipoSis ?? 'equipo',
            // $request->cOpenUsr ?? 'N',
            // $request->cMacNicSis ?? 'mac',
            // $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('CALL Sp_DGI_CRUD_PERSONAS_INSTITUCION_EDUCATIVA
            (?,?,?,?,?,?)', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iPersInstEducId            ?? null,
            $request->iPersId        ?? null,
            $request->iInstEducId  ?? null,

            // $request->iEstado ?? 1,
            // $request->bHabilitado ?? true,

            // $request->cEquipoSis ?? 'equipo',
            // $request->cOpenUsr ?? 'N',
            // $request->cMacNicSis ?? 'mac',
            // $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('CALL Sp_DGI_CRUD_PERSONAS_INSTITUCION_EDUCATIVA
            (?,?,?,?,?,?)', $parametros);

            if ($data[0]->iPersInstEducId > 0) {

                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
                $codeResponse = 200;
            } else {
                $response = ['validated' => true, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {

            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'exception' => $e];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }
}
