<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;



class PadronVacanteController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [


            $request->opcion,
            $request->valorBusqueda ?? '-',


            $request->iPadrVacaId                                        ?? NULL,
            $request->iAniEducdId                                        ?? NULL,
            $request->iInstEducId                                        ?? NULL,
            $request->iNiveEducId                                    ?? NULL,
            $request->iTipoIndiId                                    ?? NULL,
            // $request->iGradEducId                                    ?? NULL,
            // $request->iSeccEducId                                    ?? NULL,
            $request->iPadrVacaDocente                                ?? NULL,
            $request->iPadrVacaAula                                    ?? NULL,
            $request->dPadrVacaFechaIni                                ?? NULL,
            $request->nPadrVacaArea                                    ?? NULL,
            $request->nPadrVacaArea_Ocupada                            ?? NULL,
            $request->nPadrVacaArea_Final                            ?? NULL,
            $request->iPadrVacaAforo                                    ?? NULL,
            $request->iPadrVacaTotal_Estu_Promovidos                    ?? NULL,
            $request->iPadrVacaTotal_Vacante                        ?? NULL,

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true, //20

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('CALL Sp_DGI_CRUD_PADRON_VACANTE
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'message' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '',

            $request->iPadrVacaId                                        ?? NULL,
            $request->iAniEducdId                                        ?? NULL,
            $request->iInstEducId                                        ?? NULL,
            $request->iNiveEducId                                    ?? NULL,
            $request->iTipoIndiId                                    ?? NULL,
            // $request->iGradEducId                                    ?? NULL,
            // $request->iSeccEducId                                    ?? NULL,
            $request->iPadrVacaDocente                                ?? NULL,
            $request->iPadrVacaAula                                    ?? NULL,
            $request->dPadrVacaFechaIni                                ?? NULL,
            $request->nPadrVacaArea                                    ?? NULL,
            $request->nPadrVacaArea_Ocupada                            ?? NULL,
            $request->nPadrVacaArea_Final                            ?? NULL,
            $request->iPadrVacaAforo                                    ?? NULL,
            $request->iPadrVacaTotal_Estu_Promovidos                    ?? NULL,
            $request->iPadrVacaTotal_Vacante                        ?? NULL,

            $request->iEstado       ?? 1,
            $request->bHabilitado   ?? 1,

            $request->cEquipoSis    ?? 'equipo',
            $request->ip(),
            $request->cOpenUsr      ?? 'N',
            $request->cMacNicSis    ?? 'mac',

            $request->iCredId //31

        ];

        try {

            $data = DB::select('CALL Sp_DGI_CRUD_PADRON_VACANTE
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);

            if ($data[0]->iPadrVacaId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                $codeResponse = 200;
            } else {
                $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }
}
