<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class PadronSiagieController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iPadrSiagId                    ?? NULL,
            $request->iPadrId                        ?? NULL,
            $request->cPadrSiagDNI                     ?? NULL,
            $request->cPadrSiagDEPARTAMENTO            ?? NULL,
            $request->cPadrSiagPROVINCIA               ?? NULL,
            $request->cPadrSiagDISTRITO                ?? NULL,
            $request->cPadrSiagD_GESTION               ?? NULL,
            $request->cPadrSiagUGEL                    ?? NULL,
            $request->cPadrSiagNIVEL                   ?? NULL,
            $request->cPadrSiagNOMBRE_IE               ?? NULL,
            $request->cPadrSiagCOD_MOD                 ?? NULL,
            $request->cPadrSiagANEXO                   ?? NULL,
            $request->cPadrSiagDSC_GRADO               ?? NULL,
            $request->cPadrSiagDSC_SECCION             ?? NULL,
            $request->cPadrSiagVALIDACION_DNI          ?? NULL,
            $request->cPadrSiagCODIGO_ESTUDIANTE       ?? NULL,
            $request->cPadrSiagAPELLIDO_PATERNO        ?? NULL,
            $request->cPadrSiagAPELLIDO_MATERNO        ?? NULL,
            $request->cPadrSiagNOMBRES                 ?? NULL,
            $request->cPadrSiagFECHA_NACIMIENTO        ?? NULL,
            $request->cPadrSiagSEXO                    ?? NULL,
            $request->cPadrSiagDSC_ESTADO_MATRICULA    ?? NULL,
            $request->cPadrSiagDSC_GRADO_REP           ?? NULL,
            $request->cPadrSiagEDAD_31_MARZO           ?? NULL,
            $request->cPadrSiagFECHA_REGISTRO          ?? NULL,

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('exec DGI.Sp_DGI_CRUD_PADRON_SIAGIE
            ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '',

            $request->iPadrSiagId                    ?? NULL,
            $request->iPadrId                        ?? NULL,
            $request->cPadrSiagDNI                     ?? NULL,
            $request->cPadrSiagDEPARTAMENTO            ?? NULL,
            $request->cPadrSiagPROVINCIA               ?? NULL,
            $request->cPadrSiagDISTRITO                ?? NULL,
            $request->cPadrSiagD_GESTION               ?? NULL,
            $request->cPadrSiagUGEL                    ?? NULL,
            $request->cPadrSiagNIVEL                   ?? NULL,
            $request->cPadrSiagNOMBRE_IE               ?? NULL,
            $request->cPadrSiagCOD_MOD                 ?? NULL,
            $request->cPadrSiagANEXO                   ?? NULL,
            $request->cPadrSiagDSC_GRADO               ?? NULL,
            $request->cPadrSiagDSC_SECCION             ?? NULL,
            $request->cPadrSiagVALIDACION_DNI          ?? NULL,
            $request->cPadrSiagCODIGO_ESTUDIANTE       ?? NULL,
            $request->cPadrSiagAPELLIDO_PATERNO        ?? NULL,
            $request->cPadrSiagAPELLIDO_MATERNO        ?? NULL,
            $request->cPadrSiagNOMBRES                 ?? NULL,
            $request->cPadrSiagFECHA_NACIMIENTO        ?? NULL,
            $request->cPadrSiagSEXO                    ?? NULL,
            $request->cPadrSiagDSC_ESTADO_MATRICULA    ?? NULL,
            $request->cPadrSiagDSC_GRADO_REP           ?? NULL,
            $request->cPadrSiagEDAD_31_MARZO           ?? NULL,
            $request->cPadrSiagFECHA_REGISTRO          ?? NULL,//27

            $request->iEstado       ?? 1,
            $request->bHabilitado   ?? 1,

            $request->cEquipoSis    ?? 'equipo', //30
            $request->ip(),
            $request->cOpenUsr      ?? 'N',
            $request->cMacNicSis    ?? 'mac',

            $request->iCredId //34
        ];

        try {

            $data = DB::select('exec DGI.Sp_DGI_CRUD_PADRON_SIAGIE
            ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);

            if ($data[0]->iPadrSiagId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                $codeResponse = 200;
            } else {
                $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function import(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId,

            json_encode($request->json_padron_siagie)
        ];

        try {
            $data = DB::select('exec DGI.Sp_DGI_IMPORT_PADRON_SIAGIE ?,?,?,?,?,?', $parametros);

            $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
            $codeResponse = 200;
        } catch (\Exception $e) {

            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'exception' => $e];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }
}
