<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;



class PadronIndicadorController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [


            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iPadrIndiId               ?? NULL,
            $request->iAniEducdId           ?? NULL,
            $request->iInstEducId           ?? NULL,
            $request->iTipoIndaId           ?? NULL,
            $request->cPadrIndiNombre           ?? NULL,
            $request->cPadrIndiDescripcion      ?? NULL,
            $request->cPadrIndiAbreviatura      ?? NULL,
            $request->iPadrIndiPorcentaje       ?? NULL,
            $request->cPadrIndiFecInicio    ?? NULL,
            $request->cPadrIndiFecCierre        ?? NULL,
            $request->cPadrIndiFecPlazo        ?? NULL,

            $request->iPadrIndiInst	           ?? NULL,
            $request->iPadrIndiInfr	           ?? NULL,
            $request->iPadrIndiDire	           ?? NULL,
            $request->iPadrIndiUgel	           ?? NULL,
            $request->iPadrIndiPeda	           ?? NULL,

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo', //10
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('CALL Sp_DGI_CRUD_PADRON_INDICADOR
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'message' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '',

            $request->iPadrIndiId               ?? NULL,
            $request->iAniEducdId           ?? NULL,
            $request->iInstEducId           ?? NULL,
            $request->iTipoIndaId           ?? NULL,
            $request->cPadrIndiNombre           ?? NULL,
            $request->cPadrIndiDescripcion      ?? NULL,
            $request->cPadrIndiAbreviatura      ?? NULL,
            $request->iPadrIndiPorcentaje       ?? NULL,
            $request->cPadrIndiFecInicio    ?? NULL,
            $request->cPadrIndiFecCierre        ?? NULL,
            $request->cPadrIndiFecPlazo        ?? NULL,
            
            $request->iPadrIndiInst	           ?? NULL,
            $request->iPadrIndiInfr	           ?? NULL,
            $request->iPadrIndiDire	           ?? NULL,
            $request->iPadrIndiUgel	           ?? NULL,
            $request->iPadrIndiPeda	           ?? NULL,

            $request->iEstado       ?? 1,
            $request->bHabilitado   ?? 1,

            $request->cEquipoSis    ?? 'equipo',
            $request->ip(),
            $request->cOpenUsr      ?? 'N',
            $request->cMacNicSis    ?? 'mac',

            $request->iCredId //31

        ];

        try {

            $data = DB::select('CALL Sp_DGI_CRUD_PADRON_INDICADOR
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);

            if ($data[0]->iPadrIndiId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                $codeResponse = 200;
            } else {
                $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }
}
