<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use App\Imports\DGI\PadronImport;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use Maatwebsite\Excel\Facades\Excel;
use App\padron;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;
use PhpParser\Node\Stmt\Return_;


class PadronController extends Controller
{
    public function list_import(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [


            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iPadrId                  ?? NULL,
            $request->iAniEducdId              ?? NULL,
            $request->iTipoPeriId              ?? NULL,
            $request->iTipoPadrId              ?? NULL,
            $request->iMeseId                  ?? NULL,
            $request->cPadrNombre             ?? NULL,
            $request->cPadrDescripcion        ?? NULL,
            $request->cPadrRuta               ?? NULL,//10
            $request->cPadrNombre2             ?? NULL,
            $request->cPadrDescripcion2        ?? NULL,
            $request->cPadrRuta2               ?? NULL,
            $request->cPadrNombre3             ?? NULL,
            $request->cPadrDescripcion3        ?? NULL,
            $request->cPadrRuta3               ?? NULL,
            $request->cPadrTabla               ?? NULL,
            $request->cPadrFecRegistro         ?? NULL,
            $request->cPadrFecCierre           ?? NULL,
            $request->cPadrFecProceso           ?? NULL,//20
            $request->cPadrTotal               ?? NULL,
            $request->cPadrObservacion         ?? NULL,

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true, //

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId//29

        ];

        try {
            $data = DB::select('CALL Sp_DGI_CRUD_PADRON(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);

            $response = ['validated' => true, 'mensaje' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => ($e->errorInfo[2]), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [


            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iPadrId                  ?? NULL,
            $request->iAniEducdId              ?? NULL,
            $request->iTipoPeriId              ?? NULL,
            $request->iTipoPadrId              ?? NULL,
            $request->iMeseId                  ?? NULL,
            $request->cPadrNombre             ?? NULL,
            $request->cPadrDescripcion        ?? NULL,
            $request->cPadrRuta               ?? NULL,//10
            $request->cPadrNombre2             ?? NULL,
            $request->cPadrDescripcion2        ?? NULL,
            $request->cPadrRuta2               ?? NULL,
            $request->cPadrNombre3             ?? NULL,
            $request->cPadrDescripcion3        ?? NULL,
            $request->cPadrRuta3               ?? NULL,
            $request->cPadrTabla               ?? NULL,
            $request->cPadrFecRegistro         ?? NULL,
            $request->cPadrFecCierre           ?? NULL,
            $request->cPadrFecProceso           ?? NULL,//20
            $request->cPadrTotal               ?? NULL,
            $request->cPadrObservacion         ?? NULL,

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true, //20

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('CALL Sp_DGI_CRUD_PADRON(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
           
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'message' => ($e->errorInfo[2]), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '',

            $request->iPadrId                  ?? NULL,
            $request->iAniEducdId              ?? NULL,
            $request->iTipoPeriId              ?? NULL,
            $request->iTipoPadrId              ?? NULL,
            $request->iMeseId                  ?? NULL,
            $request->cPadrNombre             ?? NULL,
            $request->cPadrDescripcion        ?? NULL,
            $request->cPadrRuta               ?? NULL,
            $request->cPadrNombre2             ?? NULL,
            $request->cPadrDescripcion2        ?? NULL,
            $request->cPadrRuta2               ?? NULL,
            $request->cPadrNombre3             ?? NULL,
            $request->cPadrDescripcion3        ?? NULL,
            $request->cPadrRuta3               ?? NULL,
            $request->cPadrTabla               ?? NULL,
            $request->cPadrFecRegistro         ?? NULL,
            $request->cPadrFecCierre           ?? NULL,
            $request->cPadrFecProceso           ?? NULL,
            $request->cPadrTotal               ?? NULL,
            $request->cPadrObservacion         ?? NULL,

            $request->iEstado       ?? 1,
            $request->bHabilitado   ?? 1,

            $request->cEquipoSis    ?? 'equipo',
            $request->ip(),
            $request->cOpenUsr      ?? 'N',
            $request->cMacNicSis    ?? 'mac',

            $request->iCredId

        ];

        try {

            $data = DB::select('CALL Sp_DGI_CRUD_PADRON(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            return $data;
            if ($data[0]->iPadrId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                $codeResponse = 200;
                
            } else {
                $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => ($e->errorInfo[2]), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function import_excel(Request $request)
    {
        //OBTENEMOS EL TIPO O CÓDIGO(ABREVIATURA) SEGÚN el iPadrId
        //         WEB
        // NOMINAL_DIT
        // SIAGIE_DIT
        // SIAGIE_CON
        // SIAGIE_REI
        //
        $cTipoPadrAbreviatura = DB::select("
        SELECT MAX(tp.cTipoPadrAbreviatura)  AS cTipoPadrAbreviatura
        FROM PADRON AS p
        INNER JOIN TIPO_PADRON AS tp ON tp.iTipoPadrId = p.iTipoPadrId
        WHERE p.iPadrId = " . $request->iPadrId . " 
        ");
        if (count($cTipoPadrAbreviatura) > 0) {
            switch ($cTipoPadrAbreviatura[0]->cTipoPadrAbreviatura) {
                case 'WEB':
                    return $this->import_web($request);
                    break;
                case 'NOMINAL_DIT':
                    return $this->import_nominal_dit($request);
                    break;
                case 'SIAGIE_DIT':
                    return $this->import_siagie_dit($request);
                    break;
                case 'SIAGIE_CON':
                    return $this->import_siagie_con($request);
                    break;
                case 'SIAGIE_REI':
                    return $this->import_siagie_rei($request);
                    break;
                default:
                    $response = ['validated' => false, 'mensaje' => 'No se logró importar y/o no se encontró el tipo de padrón.'];
                    $codeResponse = 200;

                    return response()->json($response, $codeResponse);

                    break;
            }
        } else {
            //AQUI ERROR RETURN
            $response = ['validated' => false, 'mensaje' => 'No se logró importar y/o no se encontró el tipo de padrón.'];
            $codeResponse = 200;

            return response()->json($response, $codeResponse);
        }

        //return $cTipoPadrAbreviatura;

    }
    //
    public function import_web(Request $request)
    {
        $cPadrTabla = DB::table('PADRON as p')
            ->select('p.cPadrTabla', 'p.cPadrRuta')
            ->where('iPadrId', $request->iPadrId)
            ->get();

        $iPadrWebId = DB::table("PADRON_" . $cPadrTabla[0]->cPadrTabla)
            ->where('iPadrId', $request->iPadrId)
            ->count();
        if ($iPadrWebId > 0) {
            //return 'YA TIENE REGISTROS';
            $response = ['validated' => false, 'mensaje' => 'YA TIENE REGISTROS.'];
            $codeResponse = 200;
        } else {
            //return 'NO';

            $data = Excel::toArray('', public_path('documentos/') . $cPadrTabla[0]->cPadrRuta);

            if (count($data) > 0) {

                $total = count($data[0]) - 1;
                $respaldo = count($data[0]) - 1;
                $k = 0;

                for ($j = 1; $j <= $total; $j = $j + 1000) {
                    //sleep(5);
                    if ($respaldo < 1000) {
                        $limite = $respaldo;
                    } else {
                        $limite = 1000;
                    }
                    set_time_limit(120);
                    ini_set('memory_limit', '1024M');
                    $iPadrId = '';
                    for ($i = 1; $i <= $limite; $i++) {
                        $k = $k + 1;
                        if ($i == 1) {
                            $sel = ' SELECT';
                        } else {
                            $sel = ' UNION ALL SELECT ';
                        }

                        $cPadrWebCOD_MOD          = $data[0][$k][0] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][0]))) : '-';
                        $cPadrWebANEXO            = $data[0][$k][1] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][1]))) : '-';
                        $cPadrWebCODLOCAL         = $data[0][$k][2] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][2]))) : '-';
                        $cPadrWebCEN_EDU          = $data[0][$k][3] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][3]))) : '-';
                        $cPadrWebNIV_MOD          = $data[0][$k][4] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][4]))) : '-';
                        $cPadrWebD_NIV_MOD        = $data[0][$k][5] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][5]))) : '-';
                        $cPadrWebD_FORMA          = $data[0][$k][6] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][6]))) : '-';
                        $cPadrWebCOD_CAR          = $data[0][$k][7] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][7]))) : '-';
                        $cPadrWebD_COD_CAR        = $data[0][$k][8] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][8]))) : '-';
                        $cPadrWebTIPSSEXO         = $data[0][$k][9] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][9]))) : '-';
                        $cPadrWebD_TIPSSEXO       = $data[0][$k][10] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][10]))) : '-';
                        $cPadrWebGESTION          = $data[0][$k][11] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][11]))) : '-';
                        $cPadrWebD_GESTION        = $data[0][$k][12] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][12]))) : '-';
                        $cPadrWebGES_DEP          = $data[0][$k][13] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][13]))) : '-';
                        $cPadrWebD_GES_DEP        = $data[0][$k][14] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][14]))) : '-';
                        $cPadrWebDIRECTOR         = $data[0][$k][15] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][15]))) : '-';
                        $cPadrWebTELEFONO         = $data[0][$k][16] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][16]))) : '-';
                        $cPadrWebEMAIL            = $data[0][$k][17] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][17]))) : '-';
                        $cPadrWebPAGWEB           = $data[0][$k][18] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][18]))) : '-';
                        $cPadrWebDIR_CEN          = $data[0][$k][19] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][19]))) : '-';
                        $cPadrWebREFERENCIA       = $data[0][$k][20] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][20]))) : '-';
                        $cPadrWebLOCALIDAD        = $data[0][$k][21] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][21]))) : '-';
                        $cPadrWebCODCP_INEI       = $data[0][$k][22] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][22]))) : '-';
                        $cPadrWebCODCCPP          = $data[0][$k][23] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][23]))) : '-';
                        $cPadrWebCEN_POB          = $data[0][$k][24] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][24]))) : '-';
                        $cPadrWebAREA_CENSO       = $data[0][$k][25] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][25]))) : '-';
                        $cPadrWebDAREACENSO       = $data[0][$k][26] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][26]))) : '-';
                        $cPadrWebCODGEO           = $data[0][$k][27] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][27]))) : '-';
                        $cPadrWebD_DPTO           = $data[0][$k][28] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][28]))) : '-';
                        $cPadrWebD_PROV           = $data[0][$k][29] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][29]))) : '-';
                        $cPadrWebD_DIST           = $data[0][$k][30] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][30]))) : '-';
                        $cPadrWebD_REGION         = $data[0][$k][31] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][31]))) : '-';
                        $cPadrWebCODOOII          = $data[0][$k][32] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][32]))) : '-';
                        $cPadrWebD_DREUGEL        = $data[0][$k][33] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][33]))) : '-';
                        $cPadrWebNLAT_IE          = $data[0][$k][34] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][34]))) : '-';
                        $cPadrWebNLONG_IE         = $data[0][$k][35] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][35]))) : '-';
                        $cPadrWebTIPOPROG         = $data[0][$k][36] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][36]))) : '-';
                        $cPadrWebD_TIPOPROG       = $data[0][$k][37] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][37]))) : '-';
                        $cPadrWebCOD_TUR          = $data[0][$k][38] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][38]))) : '-';
                        $cPadrWebD_COD_TUR        = $data[0][$k][39] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][39]))) : '-';
                        $cPadrWebESTADO           = $data[0][$k][40] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][40]))) : '-';
                        $cPadrWebD_ESTADO         = $data[0][$k][41] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][41]))) : '-';
                        $cPadrWebD_FTE_DATO       = $data[0][$k][42] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][42]))) : '-';
                        $cPadrWebTALUM_HOM        = $data[0][$k][43] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][43]))) : '-';
                        $cPadrWebTALUM_MUJ        = $data[0][$k][44] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][44]))) : '-';
                        $cPadrWebTALUMNO          = $data[0][$k][45] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][45]))) : '-';
                        $cPadrWebTDOCENTE         = $data[0][$k][46] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][46]))) : '-';
                        $cPadrWebTSECCION         = $data[0][$k][47] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][47]))) : '-';
                        $cPadrWebFECHAREG         = $data[0][$k][48] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][48]))) : '-';
                        $cPadrWebFECHA_ACT        = $data[0][$k][49] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT//IGNORE", trim($data[0][$k][49]))) : '-';

                        $iPadrId = $iPadrId . $sel . "      
                        " . $request->iPadrId . " , 
                        '" . $cPadrWebCOD_MOD . "' ,       
                        '" . $cPadrWebANEXO . "' ,         
                        '" . $cPadrWebCODLOCAL . "' ,      
                        '" . $cPadrWebCEN_EDU . "' ,       
                        '" . $cPadrWebNIV_MOD . "' ,       
                        '" . $cPadrWebD_NIV_MOD . "' ,     
                        '" . $cPadrWebD_FORMA . "' ,       
                        '" . $cPadrWebCOD_CAR . "' ,       
                        '" . $cPadrWebD_COD_CAR . "' ,     
                        '" . $cPadrWebTIPSSEXO . "' ,      
                        '" . $cPadrWebD_TIPSSEXO . "' ,    
                        '" . $cPadrWebGESTION . "' ,       
                        '" . $cPadrWebD_GESTION . "' ,     
                        '" . $cPadrWebGES_DEP . "' ,       
                        '" . $cPadrWebD_GES_DEP . "' ,     
                        '" . $cPadrWebDIRECTOR . "' ,      
                        '" . $cPadrWebTELEFONO . "' ,      
                        '" . $cPadrWebEMAIL . "' ,         
                        '" . $cPadrWebPAGWEB . "' ,        
                        '" . $cPadrWebDIR_CEN . "' ,       
                        '" . $cPadrWebREFERENCIA . "' ,    
                        '" . $cPadrWebLOCALIDAD . "' ,     
                        '" . $cPadrWebCODCP_INEI . "' ,    
                        '" . $cPadrWebCODCCPP . "' ,       
                        '" . $cPadrWebCEN_POB . "' ,       
                        '" . $cPadrWebAREA_CENSO . "' ,   
                        '" . $cPadrWebDAREACENSO . "' ,    
                        '" . $cPadrWebCODGEO . "' ,        
                        '" . $cPadrWebD_DPTO . "' ,        
                        '" . $cPadrWebD_PROV . "' ,        
                        '" . $cPadrWebD_DIST . "' ,        
                        '" . $cPadrWebD_REGION . "' ,      
                        '" . $cPadrWebCODOOII . "' ,       
                        '" . $cPadrWebD_DREUGEL . "' ,     
                        '" . $cPadrWebNLAT_IE . "' ,       
                        '" . $cPadrWebNLONG_IE . "' ,      
                        '" . $cPadrWebTIPOPROG . "' ,      
                        '" . $cPadrWebD_TIPOPROG . "' ,    
                        '" . $cPadrWebCOD_TUR . "' ,       
                        '" . $cPadrWebD_COD_TUR . "' ,     
                        '" . $cPadrWebESTADO . "' ,        
                        '" . $cPadrWebD_ESTADO . "' ,      
                        '" . $cPadrWebD_FTE_DATO . "' ,    
                        '" . $cPadrWebTALUM_HOM . "' ,     
                        '" . $cPadrWebTALUM_MUJ . "' ,     
                        '" . $cPadrWebTALUMNO . "' ,       
                        '" . $cPadrWebTDOCENTE . "' ,      
                        '" . $cPadrWebTSECCION . "' ,      
                        '" . $cPadrWebFECHAREG . "' ,
                        '" . $cPadrWebFECHA_ACT . "'  ";
                        
                    }
                    $tabla = DB::select(" INSERT INTO PADRON_" . $cPadrTabla[0]->cPadrTabla . " (
                        iPadrId,
                        cPadrWebCOD_MOD,       
                        cPadrWebANEXO,         
                        cPadrWebCODLOCAL,      
                        cPadrWebCEN_EDU,       
                        cPadrWebNIV_MOD,       
                        cPadrWebD_NIV_MOD,     
                        cPadrWebD_FORMA,       
                        cPadrWebCOD_CAR,       
                        cPadrWebD_COD_CAR,     
                        cPadrWebTIPSSEXO,      
                        cPadrWebD_TIPSSEXO,    
                        cPadrWebGESTION,       
                        cPadrWebD_GESTION,     
                        cPadrWebGES_DEP,       
                        cPadrWebD_GES_DEP,     
                        cPadrWebDIRECTOR,      
                        cPadrWebTELEFONO,      
                        cPadrWebEMAIL,         
                        cPadrWebPAGWEB,        
                        cPadrWebDIR_CEN,       
                        cPadrWebREFERENCIA,    
                        cPadrWebLOCALIDAD,     
                        cPadrWebCODCP_INEI,    
                        cPadrWebCODCCPP,       
                        cPadrWebCEN_POB,       
                        cPadrWebAREA_CENSO,   
                        cPadrWebDAREACENSO,    
                        cPadrWebCODGEO,        
                        cPadrWebD_DPTO,        
                        cPadrWebD_PROV,        
                        cPadrWebD_DIST,        
                        cPadrWebD_REGION,      
                        cPadrWebCODOOII,       
                        cPadrWebD_DREUGEL,     
                        cPadrWebNLAT_IE,       
                        cPadrWebNLONG_IE,      
                        cPadrWebTIPOPROG,      
                        cPadrWebD_TIPOPROG,    
                        cPadrWebCOD_TUR,       
                        cPadrWebD_COD_TUR,     
                        cPadrWebESTADO,        
                        cPadrWebD_ESTADO,      
                        cPadrWebD_FTE_DATO,    
                        cPadrWebTALUM_HOM,     
                        cPadrWebTALUM_MUJ,     
                        cPadrWebTALUMNO,       
                        cPadrWebTDOCENTE,      
                        cPadrWebTSECCION,      
                        cPadrWebFECHAREG,
                        cPadrWebFECHA_ACT
                    )   " . $iPadrId . " SELECT LAST_INSERT_ID() AS iPadrWebId");
                    $respaldo = $respaldo - 1000;
                }


                if ($tabla[0]->iPadrWebId > 0) {
                    $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
                    $codeResponse = 200;
                } else {
                    $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                    $codeResponse = 500;
                }
            }
        }
        return response()->json($response, $codeResponse);
    }

    public function import_nominal_dit(Request $request)
    {      
        $cPadrTabla = DB::table('PADRON as p')
            ->select('p.cPadrTabla', 'p.cPadrRuta')
            ->where('iPadrId', $request->iPadrId)
            ->get();

        $iPadrNomiId = DB::table("PADRON_" . $cPadrTabla[0]->cPadrTabla)
            ->where('iPadrId', $request->iPadrId)
            ->count();
        if ($iPadrNomiId > 0) {
            //return 'YA TIENE REGISTROS';
            $response = ['validated' => false, 'mensaje' => 'YA TIENE REGISTROS.'];
            $codeResponse = 200;
        } else {
            //return 'NO';

            $data = Excel::toArray('', public_path('documentos/') . $cPadrTabla[0]->cPadrRuta);

            // if (count($data) > 0) {

            //     $total = count($data[0]) - 1;
            //     $respaldo = count($data[0]) - 1;
            //     $k = 0;

            //     $parametros = [
            //         'GUARDAR',
            //         $total ?? '', // CANTIDAD ENVIAMOS
        
            //         $request->iPadrNomiId			?? NULL,	
            //         $request->iPadrId				?? NULL,	
                   
                   
            //         NULL,//AQUI DATA ENVIAMOS DESPUÉS $data[0]
        
            //         $request->iEstado       ?? 1,
            //         $request->bHabilitado   ?? 1,
        
            //         $request->cEquipoSis    ?? 'equipo',//70
            //         $request->ip(),
            //         $request->cOpenUsr      ?? 'N',
            //         $request->cMacNicSis    ?? 'mac',
        
            //         $request->iCredId//74
            //     ];

            //     try {

            //         $data = DB::select('CALL Sp_DGI_CRUD_PRUEBA
            //         ?,?,?,?,?,?,?,?,?,?,?,?', $parametros);
                
            //         if ($data[0]->iPadrNomiId > 0) {
            //             $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
            //             $codeResponse = 200;
            //         } else {
            //             $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
            //             $codeResponse = 500;
            //         }
            //     } catch (\Exception $e) {
            //         $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), $e->getMessage(), 'data' => []];
            //         $codeResponse = 500;
            //     }

               
            
            //     $data = DB::select(
            //         "
            //         SET NOCOUNT ON 
            //         DECLARE @iPadrNomiId INT 
            //         DECLARE @_i INT = 1 , @_counter INT = ".$total."
            //                 WHILE (@_i<=@_counter)
            //                     BEGIN
            //                         INSERT INTO PADRON_2022ENERONOMINAL_DIT (iPadrId)
            //                         VALUES (".$request->iPadrId.")
            //                         SET @iPadrNomiId=@@IDENTITY	
            //                         SET @_i = @_i+1
            //                     END
            //                     SELECT @iPadrNomiId AS iPadrNomiId

            //         "

            //     );
            //     $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.','data'=>$data];
            //     $codeResponse = 200;

            //    return $data;


            if (count($data) > 0) {

                $total = count($data[0]) - 1;
                $respaldo = count($data[0]) - 1;
                $k = 0;
    
                for ($j = 1; $j <= $total; $j = $j + 1000) {
                    //sleep(5);
                    if ($respaldo < 1000) {
                        $limite = $respaldo;
                    } else {
                        $limite = 1000;
                    }
                    set_time_limit(90);
                    ini_set('memory_limit', '1024M');
                    $iPadrId = '';
                    for ($i = 1; $i <= $limite; $i++) {
                        $k = $k + 1;
                        if ($i == 1) {
                            $sel = ' SELECT';
                        } else {
                            $sel = ' UNION ALL SELECT ';
                        }
                            $cPadrNomiTIP_DOC		    = $data[0][$k][0] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][0]))) : '-';
                            $cPadrNomiCOD_PAD           = $data[0][$k][1] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][1]))) : '-';
                            $cPadrNomiCOD_CNV           = $data[0][$k][2] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][2]))) : '-';
                            $cPadrNomiCOD_CUI           = $data[0][$k][3] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][3]))) : '-';
                            $cPadrNomiMEN_NRO_DNI       = $data[0][$k][4] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][4]))) : '-';
                            $cPadrNomiMEN_EST_TRA       = $data[0][$k][5] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][5]))) : '-';
                            $cPadrNomiFEC_TRA           = $data[0][$k][6] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][6]))) : '-';
                            $cPadrNomiMEN_APE_PAT       = $data[0][$k][7] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][7]))) : '-';
                            $cPadrNomiMEN_APE_MAT       = $data[0][$k][8] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][8]))) : '-';
                            $cPadrNomiMEN_NOM           = $data[0][$k][9] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][9]))) : '-';
                            $cPadrNomiMEN_COD_SEX       = $data[0][$k][10] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][10]))) : '-';
                            $cPadrNomiMEN_FEC_NAC       = $data[0][$k][11] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][11]))) : '-';
                            $cPadrNomiMEN_EDA_AMD       = $data[0][$k][12] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][12]))) : '-';
                            $cPadrNomiEJE_VIA           = $data[0][$k][13] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][13]))) : '-';
                            $cPadrNomiDIR_DES           = $data[0][$k][14] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][14]))) : '-';
                            $cPadrNomiREF_DIR           = $data[0][$k][15] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][15]))) : '-';
                            $cPadrNomiCOD_UBI           = $data[0][$k][16] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][16]))) : '-';
                            $cPadrNomiNOM_DEP           = $data[0][$k][17] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][17]))) : '-';
                            $cPadrNomiNOM_PRO           = $data[0][$k][18] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][18]))) : '-';
                            $cPadrNomiNOM_DIS           = $data[0][$k][19] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][19]))) : '-';
                            $cPadrNomiCOD_CEN_POB       = $data[0][$k][20] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][20]))) : '-';
                            $cPadrNomiNOM_CEN_POB       = $data[0][$k][21] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][21]))) : '-';
                            $cPadrNomiCAR_CEN_POB       = $data[0][$k][22] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][22]))) : '-';
                            $cPadrNomiVIS_MEN           = $data[0][$k][23] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][23]))) : '-';
                            $cPadrNomiVIS_ENC           = $data[0][$k][24] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][24]))) : '-';
                            $cPadrNomiVIS_FEC           = $data[0][$k][25] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][25]))) : '-';
                            $cPadrNomiFUE_INS           = $data[0][$k][26] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][26]))) : '-';
                            $cPadrNomiFUE_FEC           = $data[0][$k][27] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][27]))) : '-';
                            $cPadrNomiCOD_EESS_NAC      = $data[0][$k][28] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][28]))) : '-';
                            $cPadrNomiNOM_EESS_NAC      = $data[0][$k][29] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][29]))) : '-';
                            $cPadrNomiCOD_EESS          = $data[0][$k][30] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][30]))) : '-';
                            $cPadrNomiNOM_EESS          = $data[0][$k][31] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][31]))) : '-';
                            $cPadrNomiFRE_ATE           = $data[0][$k][32] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][32]))) : '-';
                            $cPadrNomiCOD_EESS_ADS      = $data[0][$k][33] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][33]))) : '-';
                            $cPadrNomiNOM_EESS_ADS      = $data[0][$k][34] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][34]))) : '-';
                            $cPadrNomiTIP_SEG           = $data[0][$k][35] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][35]))) : '-';
                            $cPadrNomiTIP_PRO_SOC       = $data[0][$k][36] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][36]))) : '-';
                            $cPadrNomiCOD_IIEE          = $data[0][$k][37] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][37]))) : '-';
                            $cPadrNomiNOM_IIEE          = $data[0][$k][38] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][38]))) : '-';
                            $cPadrNomiFAM_TIP           = $data[0][$k][39] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][39]))) : '-';
                            $cPadrNomiFAM_TIP_DOC       = $data[0][$k][40] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][40]))) : '-';
                            $cPadrNomiFAM_NRO_DOC       = $data[0][$k][41] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][41]))) : '-';
                            $cPadrNomiFAM_APE_PAT       = $data[0][$k][42] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][42]))) : '-';
                            $cPadrNomiFAM_APE_MAT       = $data[0][$k][43] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][43]))) : '-';
                            $cPadrNomiFAM_NOM           = $data[0][$k][44] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][44]))) : '-';
                            $cPadrNomiFAM_CEL           = $data[0][$k][45] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][45]))) : '-';
                            $cPadrNomiFAM_EMA           = $data[0][$k][46] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][46]))) : '-';
                            $cPadrNomiFAM_GRA_INS       = $data[0][$k][47] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][47]))) : '-';
                            $cPadrNomiFAM_LEN_HAB       = $data[0][$k][48] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][48]))) : '-';
                            $cPadrNomiJEF_TIP           = $data[0][$k][49] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][49]))) : '-';
                            $cPadrNomiJEF_TIP_DOC       = $data[0][$k][50] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][50]))) : '-';
                            $cPadrNomiJEF_NRO_DOC       = $data[0][$k][51] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][51]))) : '-';
                            $cPadrNomiJEF_APE_PAT       = $data[0][$k][52] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][52]))) : '-';
                            $cPadrNomiJEF_APE_MAT       = $data[0][$k][53] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][53]))) : '-';
                            $cPadrNomiJEF_NOM           = $data[0][$k][54] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][54]))) : '-';
                            $cPadrNomiREG_EST           = $data[0][$k][55] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][55]))) : '-';
                            $cPadrNomiREG_FEC_CRE       = $data[0][$k][56] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][56]))) : '-';
                            $cPadrNomiREG_USU           = $data[0][$k][57] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][57]))) : '-';
                            $cPadrNomiREG_FEC_MOD       = $data[0][$k][58] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][58]))) : '-';
                            $cPadrNomiREG_USU_MOD       = $data[0][$k][59] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][59]))) : '-';
                            $cPadrNomiREG_ENT           = $data[0][$k][60] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][60]))) : '-';
                            $cPadrNomiREG_TIP           = $data[0][$k][61] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][61]))) : '-';
                            $cPadrNomiCIE_EDA		    = $data[0][$k][62] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][62]))) : '-';
                        
                            $iPadrId = $iPadrId . $sel . "      
                        " . $request->iPadrId . " , 
                        '" . $cPadrNomiTIP_DOC . "' ,     
                        '" . $cPadrNomiCOD_PAD . "' ,     
                        '" . $cPadrNomiCOD_CNV . "' ,     
                        '" . $cPadrNomiCOD_CUI . "' ,     
                        '" . $cPadrNomiMEN_NRO_DNI . "' , 
                        '" . $cPadrNomiMEN_EST_TRA . "' , 
                        '" . $cPadrNomiFEC_TRA . "' ,     
                        '" . $cPadrNomiMEN_APE_PAT . "' , 
                        '" . $cPadrNomiMEN_APE_MAT . "' , 
                        '" . $cPadrNomiMEN_NOM . "' ,     
                        '" . $cPadrNomiMEN_COD_SEX . "' , 
                        '" . $cPadrNomiMEN_FEC_NAC . "' , 
                        '" . $cPadrNomiMEN_EDA_AMD . "' , 
                        '" . $cPadrNomiEJE_VIA . "' ,     
                        '" . $cPadrNomiDIR_DES . "' ,     
                        '" . $cPadrNomiREF_DIR . "' ,     
                        '" . $cPadrNomiCOD_UBI . "' ,     
                        '" . $cPadrNomiNOM_DEP . "' ,     
                        '" . $cPadrNomiNOM_PRO . "' ,     
                        '" . $cPadrNomiNOM_DIS . "' ,     
                        '" . $cPadrNomiCOD_CEN_POB . "' , 
                        '" . $cPadrNomiNOM_CEN_POB . "' , 
                        '" . $cPadrNomiCAR_CEN_POB . "' , 
                        '" . $cPadrNomiVIS_MEN . "' ,     
                        '" . $cPadrNomiVIS_ENC . "' ,     
                        '" . $cPadrNomiVIS_FEC . "' ,     
                        '" . $cPadrNomiFUE_INS . "' ,     
                        '" . $cPadrNomiFUE_FEC . "' ,     
                        '" . $cPadrNomiCOD_EESS_NAC . "' ,
                        '" . $cPadrNomiNOM_EESS_NAC . "' ,
                        '" . $cPadrNomiCOD_EESS . "' ,    
                        '" . $cPadrNomiNOM_EESS . "' ,    
                        '" . $cPadrNomiFRE_ATE . "' ,     
                        '" . $cPadrNomiCOD_EESS_ADS . "' ,
                        '" . $cPadrNomiNOM_EESS_ADS . "' ,
                        '" . $cPadrNomiTIP_SEG . "' ,     
                        '" . $cPadrNomiTIP_PRO_SOC . "' , 
                        '" . $cPadrNomiCOD_IIEE . "' ,    
                        '" . $cPadrNomiNOM_IIEE . "' ,    
                        '" . $cPadrNomiFAM_TIP . "' ,     
                        '" . $cPadrNomiFAM_TIP_DOC . "' , 
                        '" . $cPadrNomiFAM_NRO_DOC . "' , 
                        '" . $cPadrNomiFAM_APE_PAT . "' , 
                        '" . $cPadrNomiFAM_APE_MAT . "' , 
                        '" . $cPadrNomiFAM_NOM . "' ,     
                        '" . $cPadrNomiFAM_CEL . "' ,     
                        '" . $cPadrNomiFAM_EMA . "' ,     
                        '" . $cPadrNomiFAM_GRA_INS . "' , 
                        '" . $cPadrNomiFAM_LEN_HAB . "' , 
                        '" . $cPadrNomiJEF_TIP . "' ,     
                        '" . $cPadrNomiJEF_TIP_DOC . "' , 
                        '" . $cPadrNomiJEF_NRO_DOC . "' , 
                        '" . $cPadrNomiJEF_APE_PAT . "' , 
                        '" . $cPadrNomiJEF_APE_MAT . "' , 
                        '" . $cPadrNomiJEF_NOM . "' ,     
                        '" . $cPadrNomiREG_EST . "' ,     
                        '" . $cPadrNomiREG_FEC_CRE . "' , 
                        '" . $cPadrNomiREG_USU . "' ,     
                        '" . $cPadrNomiREG_FEC_MOD . "' , 
                        '" . $cPadrNomiREG_USU_MOD . "' , 
                        '" . $cPadrNomiREG_ENT . "' ,     
                        '" . $cPadrNomiREG_TIP . "' ,     
                        '" . $cPadrNomiCIE_EDA . "'  ";
                        
                    }
                    $tabla = DB::select(" INSERT INTO PADRON_" . $cPadrTabla[0]->cPadrTabla . " (
                        iPadrId,
                        cPadrNomiTIP_DOC,     
                        cPadrNomiCOD_PAD,     
                        cPadrNomiCOD_CNV,     
                        cPadrNomiCOD_CUI,     
                        cPadrNomiMEN_NRO_DNI, 
                        cPadrNomiMEN_EST_TRA, 
                        cPadrNomiFEC_TRA,     
                        cPadrNomiMEN_APE_PAT, 
                        cPadrNomiMEN_APE_MAT, 
                        cPadrNomiMEN_NOM,     
                        cPadrNomiMEN_COD_SEX, 
                        cPadrNomiMEN_FEC_NAC, 
                        cPadrNomiMEN_EDA_AMD, 
                        cPadrNomiEJE_VIA,     
                        cPadrNomiDIR_DES,     
                        cPadrNomiREF_DIR,     
                        cPadrNomiCOD_UBI,     
                        cPadrNomiNOM_DEP,     
                        cPadrNomiNOM_PRO,     
                        cPadrNomiNOM_DIS,     
                        cPadrNomiCOD_CEN_POB, 
                        cPadrNomiNOM_CEN_POB, 
                        cPadrNomiCAR_CEN_POB, 
                        cPadrNomiVIS_MEN,     
                        cPadrNomiVIS_ENC,     
                        cPadrNomiVIS_FEC,     
                        cPadrNomiFUE_INS,     
                        cPadrNomiFUE_FEC,     
                        cPadrNomiCOD_EESS_NAC,
                        cPadrNomiNOM_EESS_NAC,
                        cPadrNomiCOD_EESS,    
                        cPadrNomiNOM_EESS,    
                        cPadrNomiFRE_ATE,     
                        cPadrNomiCOD_EESS_ADS,
                        cPadrNomiNOM_EESS_ADS,
                        cPadrNomiTIP_SEG,     
                        cPadrNomiTIP_PRO_SOC, 
                        cPadrNomiCOD_IIEE,    
                        cPadrNomiNOM_IIEE,    
                        cPadrNomiFAM_TIP,     
                        cPadrNomiFAM_TIP_DOC, 
                        cPadrNomiFAM_NRO_DOC, 
                        cPadrNomiFAM_APE_PAT, 
                        cPadrNomiFAM_APE_MAT, 
                        cPadrNomiFAM_NOM,     
                        cPadrNomiFAM_CEL,     
                        cPadrNomiFAM_EMA,     
                        cPadrNomiFAM_GRA_INS, 
                        cPadrNomiFAM_LEN_HAB, 
                        cPadrNomiJEF_TIP,     
                        cPadrNomiJEF_TIP_DOC, 
                        cPadrNomiJEF_NRO_DOC, 
                        cPadrNomiJEF_APE_PAT, 
                        cPadrNomiJEF_APE_MAT, 
                        cPadrNomiJEF_NOM,     
                        cPadrNomiREG_EST,     
                        cPadrNomiREG_FEC_CRE, 
                        cPadrNomiREG_USU,     
                        cPadrNomiREG_FEC_MOD, 
                        cPadrNomiREG_USU_MOD, 
                        cPadrNomiREG_ENT,     
                        cPadrNomiREG_TIP,     
                        cPadrNomiCIE_EDA     
                    )   " . $iPadrId . " SELECT LAST_INSERT_ID() AS iPadrNomiId");
                    $respaldo = $respaldo - 1000;
                }


                if ($tabla[0]->iPadrNomiId > 0) {
                    $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
                    $codeResponse = 200;
                } else {
                    $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                    $codeResponse = 500;
                }
            }
        }
        return response()->json($response, $codeResponse);
    }



    public function import_siagie_dit(Request $request)
    {
        $cPadrTabla = DB::table('PADRON as p')
            ->select('p.cPadrTabla', 'p.cPadrRuta')
            ->where('iPadrId', $request->iPadrId)
            ->get();

        $iPadrSiagId = DB::table("PADRON_" . $cPadrTabla[0]->cPadrTabla)
            ->where('iPadrId', $request->iPadrId)
            ->count();


        if ($iPadrSiagId > 0) {
            //return 'YA TIENE REGISTROS';
            $response = ['validated' => false, 'mensaje' => 'YA TIENE REGISTROS.'];
            $codeResponse = 200;
        } else {
            //return 'NO';

            $data = Excel::toArray('', public_path('documentos/') . $cPadrTabla[0]->cPadrRuta);

            if (count($data) > 0) {

                $total = count($data[0]) - 1;
                $respaldo = count($data[0]) - 1;
                $k = 0;

                for ($j = 1; $j <= $total; $j = $j + 1000) {
                    //sleep(5);
                    if ($respaldo < 1000) {
                        $limite = $respaldo;
                    } else {
                        $limite = 1000;
                    }
                    set_time_limit(90);
                    ini_set('memory_limit', '1024M');
                    $iPadrId = '';
                    for ($i = 1; $i <= $limite; $i++) {
                        $k = $k + 1;
                        if ($i == 1) {
                            $sel = ' SELECT';
                        } else {
                            $sel = ' UNION ALL SELECT ';
                        }


                        $cPadrSiagDNI                   = $data[0][$k][0] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][0]))) : '-';
                        $cPadrSiagCOD_UBI               = $data[0][$k][1] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][1]))) : '-';
                        $cPadrSiagDEPARTAMENTO          = $data[0][$k][2] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][2]))) : '-';
                        $cPadrSiagPROVINCIA             = $data[0][$k][3] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][3]))) : '-';
                        $cPadrSiagDISTRITO              = $data[0][$k][4] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][4]))) : '-';
                        $cPadrSiagD_GESTION             = $data[0][$k][5] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][5]))) : '-';
                        $cPadrSiagCOD_UGEL              = $data[0][$k][6] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][6]))) : '-';
                        $cPadrSiagUGEL                  = $data[0][$k][7] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][7]))) : '-';
                        $cPadrSiagNIVEL                 = $data[0][$k][8] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][8]))) : '-';
                        $cPadrSiagNOMBRE_IE             = $data[0][$k][9] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][9]))) : '-';
                        $cPadrSiagCOD_MOD               = $data[0][$k][10] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][10]))) : '-';
                        $cPadrSiagANEXO                 = $data[0][$k][11] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][11]))) : '-';
                        $cPadrSiagDSC_GRADO             = $data[0][$k][12] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][12]))) : '-';
                        $cPadrSiagDSC_SECCION           = $data[0][$k][13] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][13]))) : '-';
                        $cPadrSiagVALIDACION_DNI        = $data[0][$k][14] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][14]))) : '-';
                        $cPadrSiagCODIGO_ESTUDIANTE     = $data[0][$k][15] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][15]))) : '-';
                        $cPadrSiagAPELLIDO_PATERNO      = $data[0][$k][16] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][16]))) : '-';
                        $cPadrSiagAPELLIDO_MATERNO      = $data[0][$k][17] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][17]))) : '-';
                        $cPadrSiagNOMBRES               = $data[0][$k][18] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][18]))) : '-';
                        $cPadrSiagFECHA_NACIMIENTO      = $data[0][$k][19] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][19]))) : '-';
                        $cPadrSiagSEXO                  = $data[0][$k][20] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][20]))) : '-';
                        $cPadrSiagDSC_ESTADO_MATRICULA  = $data[0][$k][21] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][21]))) : '-';
                        $cPadrSiagDSC_GRADO_REP         = $data[0][$k][22] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][22]))) : '-';
                        $cPadrSiagEDAD_31_MARZO         = $data[0][$k][23] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][23]))) : '-';
                        $cPadrSiagFECHA_REGISTRO        = $data[0][$k][24] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][24]))) : '-';


                        $iPadrId = $iPadrId . $sel . "      
                     " . $request->iPadrId . " , 
                     '" . $cPadrSiagDNI . "' , 
                     '" . $cPadrSiagCOD_UBI . "' ,
                     '" . $cPadrSiagDEPARTAMENTO . "' , 
                     '" . $cPadrSiagPROVINCIA . "' , 
                     '" . $cPadrSiagDISTRITO . "' , 
                     '" . $cPadrSiagD_GESTION . "' , 
                     '" . $cPadrSiagCOD_UGEL . "' , 
                     '" . $cPadrSiagUGEL . "' , 
                     '" . $cPadrSiagNIVEL . "' , 
                     '" . $cPadrSiagNOMBRE_IE . "' , 
                     '" . $cPadrSiagCOD_MOD . "' , 
                     '" . $cPadrSiagANEXO . "' , 
                     '" . $cPadrSiagDSC_GRADO . "' , 
                     '" . $cPadrSiagDSC_SECCION . "' , 
                     '" . $cPadrSiagVALIDACION_DNI . "' , 
                     '" . $cPadrSiagCODIGO_ESTUDIANTE . "' , 
                     '" . $cPadrSiagAPELLIDO_PATERNO . "' , 
                     '" . $cPadrSiagAPELLIDO_MATERNO . "' , 
                     '" . $cPadrSiagNOMBRES . "' , 
                     '" . $cPadrSiagFECHA_NACIMIENTO . "' , 
                     '" . $cPadrSiagSEXO . "' , 
                     '" . $cPadrSiagDSC_ESTADO_MATRICULA . "' , 
                     '" . $cPadrSiagDSC_GRADO_REP . "' , 
                     '" . $cPadrSiagEDAD_31_MARZO . "' , 
                     '" . $cPadrSiagFECHA_REGISTRO . "'  ";
                    }
                    $tabla = DB::select(" INSERT INTO PADRON_" . $cPadrTabla[0]->cPadrTabla . " (
                    iPadrId,
                    cPadrSiagDNI,
                    cPadrSiagCOD_UBI,
                    cPadrSiagDEPARTAMENTO,
                    cPadrSiagPROVINCIA,
                    cPadrSiagDISTRITO,
                    cPadrSiagD_GESTION,
                    cPadrSiagCOD_UGEL,
                    cPadrSiagUGEL,
                    cPadrSiagNIVEL,
                    cPadrSiagNOMBRE_IE,
                    cPadrSiagCOD_MOD,
                    cPadrSiagANEXO,
                    cPadrSiagDSC_GRADO,
                    cPadrSiagDSC_SECCION,
                    cPadrSiagVALIDACION_DNI,
                    cPadrSiagCODIGO_ESTUDIANTE,
                    cPadrSiagAPELLIDO_PATERNO,
                    cPadrSiagAPELLIDO_MATERNO,
                    cPadrSiagNOMBRES,
                    cPadrSiagFECHA_NACIMIENTO,
                    cPadrSiagSEXO,
                    cPadrSiagDSC_ESTADO_MATRICULA,
                    cPadrSiagDSC_GRADO_REP,
                    cPadrSiagEDAD_31_MARZO,
                    cPadrSiagFECHA_REGISTRO
                    )   " . $iPadrId . " SELECT LAST_INSERT_ID() AS iPadrSiagId");
                    $respaldo = $respaldo - 1000;
                }

                if ($tabla[0]->iPadrSiagId > 0) {
                    $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
                    $codeResponse = 200;
                } else {
                    $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                    $codeResponse = 500;
                }
            }
        }

        return response()->json($response, $codeResponse);
    }

    public function import_siagie_rei(Request $request)
    {
        $cPadrTabla = DB::table('PADRON as p')
            ->select('p.cPadrTabla', 'p.cPadrRuta')
            ->where('iPadrId', $request->iPadrId)
            ->get();

        $iPadrSiagReiId = DB::table("PADRON_" . $cPadrTabla[0]->cPadrTabla)
            ->where('iPadrId', $request->iPadrId)
            ->count();


        if ($iPadrSiagReiId > 0) {
            //return 'YA TIENE REGISTROS';
            $response = ['validated' => false, 'mensaje' => 'YA TIENE REGISTROS.'];
            $codeResponse = 200;
        } else {
            //return 'NO';

            $data = Excel::toArray('', public_path('documentos/') . $cPadrTabla[0]->cPadrRuta);

            if (count($data) > 0) {

                $total = count($data[0]) - 1;
                $respaldo = count($data[0]) - 1;
                $k = 0;

                for ($j = 1; $j <= $total; $j = $j + 1000) {
                    //sleep(5);
                    if ($respaldo < 1000) {
                        $limite = $respaldo;
                    } else {
                        $limite = 1000;
                    }
                    set_time_limit(90);
                    ini_set('memory_limit', '1024M');
                    $iPadrId = '';
                    for ($i = 1; $i <= $limite; $i++) {
                        $k = $k + 1;
                        if ($i == 1) {
                            $sel = ' SELECT';
                        } else {
                            $sel = ' UNION ALL SELECT ';
                        }

                        $cPadrSiagReiD_DOCUMENTO		= $data[0][$k][0] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][0]))) : '-';
                        $cPadrSiagReiC_DNI              = $data[0][$k][1] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][1]))) : '-';
                        $cPadrSiagReiD_VALIDO           = $data[0][$k][2] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][2]))) : '-';
                        $cPadrSiagReiC_ESTUDIANTE       = $data[0][$k][3] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][3]))) : '-';
                        $cPadrSiagReiD_APE_PATE         = $data[0][$k][4] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][4]))) : '-';
                        $cPadrSiagReiD_APE_MATE         = $data[0][$k][5] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][5]))) : '-';
                        $cPadrSiagReiD_NOMBRES          = $data[0][$k][6] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][6]))) : '-';
                        $cPadrSiagReiF_NACI             = $data[0][$k][7] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][7]))) : '-';
                        $cPadrSiagReiD_SEXO             = $data[0][$k][8] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][8]))) : '-';
                        $cPadrSiagReiD_GRADO            = $data[0][$k][9] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][9]))) : '-';
                        $cPadrSiagReiD_SECCION          = $data[0][$k][10] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][10]))) : '-';
                        $cPadrSiagReiD_MATRICULA        = $data[0][$k][11] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][11]))) : '-';
                        $cPadrSiagReiD_SITUACION        = $data[0][$k][12] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][12]))) : '-';
                        $cPadrSiagReiD_DIRECCION        = $data[0][$k][13] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][13]))) : '-';
                        $cPadrSiagReiD_CEN_POBLADO      = $data[0][$k][14] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][14]))) : '-';
                        $cPadrSiagReiD_DIST             = $data[0][$k][15] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][15]))) : '-';
                        $cPadrSiagReiD_PROV             = $data[0][$k][16] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][16]))) : '-';
                        $cPadrSiagReiD_DEPA             = $data[0][$k][17] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][17]))) : '-';
                        $cPadrSiagReiC_MODULAR          = $data[0][$k][18] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][18]))) : '-';
                        $cPadrSiagReiC_LOCAL            = $data[0][$k][19] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][19]))) : '-';
                        $cPadrSiagReiD_IIEE             = $data[0][$k][20] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][20]))) : '-';
                        $cPadrSiagReiC_ANEXO            = $data[0][$k][21] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][21]))) : '-';
                        $cPadrSiagReiD_NIVE_MODA        = $data[0][$k][22] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][22]))) : '-';
                        $cPadrSiagReiD_GESTION          = $data[0][$k][23] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][23]))) : '-';
                        $cPadrSiagReiD_PAIS             = $data[0][$k][24] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][24]))) : '-';
                        $cPadrSiagReiD_UGEL				= $data[0][$k][25] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][25]))) : '-';
                        $cPadrSiagReiCOD_UBI			= $data[0][$k][26] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][26]))) : '-';
                        $cPadrSiagReiCOD_UGEL	        = $data[0][$k][27] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][27]))) : '-';
                        $cPadrSiagReiEDAD_31_03         = $data[0][$k][28] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][28]))) : '-';

                        $iPadrId = $iPadrId . $sel . "      
                     " . $request->iPadrId . " , 
                     '" . $cPadrSiagReiD_DOCUMENTO . "' ,	
                     '" . $cPadrSiagReiC_DNI . "' ,          
                     '" . $cPadrSiagReiD_VALIDO . "' ,       
                     '" . $cPadrSiagReiC_ESTUDIANTE . "' ,   
                     '" . $cPadrSiagReiD_APE_PATE . "' ,     
                     '" . $cPadrSiagReiD_APE_MATE . "' ,     
                     '" . $cPadrSiagReiD_NOMBRES . "' ,      
                     '" . $cPadrSiagReiF_NACI . "' ,         
                     '" . $cPadrSiagReiD_SEXO . "' ,         
                     '" . $cPadrSiagReiD_GRADO . "' ,        
                     '" . $cPadrSiagReiD_SECCION . "' ,      
                     '" . $cPadrSiagReiD_MATRICULA . "' ,    
                     '" . $cPadrSiagReiD_SITUACION . "' ,    
                     '" . $cPadrSiagReiD_DIRECCION . "' ,    
                     '" . $cPadrSiagReiD_CEN_POBLADO . "' ,  
                     '" . $cPadrSiagReiD_DIST . "' ,         
                     '" . $cPadrSiagReiD_PROV . "' ,         
                     '" . $cPadrSiagReiD_DEPA . "' ,         
                     '" . $cPadrSiagReiC_MODULAR . "' ,      
                     '" . $cPadrSiagReiC_LOCAL . "' ,        
                     '" . $cPadrSiagReiD_IIEE . "' ,         
                     '" . $cPadrSiagReiC_ANEXO . "' ,        
                     '" . $cPadrSiagReiD_NIVE_MODA . "' ,    
                     '" . $cPadrSiagReiD_GESTION . "' ,      
                     '" . $cPadrSiagReiD_PAIS . "' ,         
                     '" . $cPadrSiagReiD_UGEL . "' ,			
                     '" . $cPadrSiagReiCOD_UBI . "' ,		
                     '" . $cPadrSiagReiCOD_UGEL . "' ,	    
                     '" . $cPadrSiagReiEDAD_31_03 . "'  "; 
                    }
                    $tabla = DB::select(" INSERT INTO PADRON_" . $cPadrTabla[0]->cPadrTabla . " (
                    iPadrId,
                    cPadrSiagReiD_DOCUMENTO,	
                    cPadrSiagReiC_DNI,          
                    cPadrSiagReiD_VALIDO,       
                    cPadrSiagReiC_ESTUDIANTE,   
                    cPadrSiagReiD_APE_PATE,     
                    cPadrSiagReiD_APE_MATE,     
                    cPadrSiagReiD_NOMBRES,      
                    cPadrSiagReiF_NACI,         
                    cPadrSiagReiD_SEXO,         
                    cPadrSiagReiD_GRADO,        
                    cPadrSiagReiD_SECCION,      
                    cPadrSiagReiD_MATRICULA,    
                    cPadrSiagReiD_SITUACION,    
                    cPadrSiagReiD_DIRECCION,    
                    cPadrSiagReiD_CEN_POBLADO,  
                    cPadrSiagReiD_DIST,         
                    cPadrSiagReiD_PROV,         
                    cPadrSiagReiD_DEPA,         
                    cPadrSiagReiC_MODULAR,      
                    cPadrSiagReiC_LOCAL,        
                    cPadrSiagReiD_IIEE,         
                    cPadrSiagReiC_ANEXO,        
                    cPadrSiagReiD_NIVE_MODA,    
                    cPadrSiagReiD_GESTION,      
                    cPadrSiagReiD_PAIS,         
                    cPadrSiagReiD_UGEL,			
                    cPadrSiagReiCOD_UBI,		
                    cPadrSiagReiCOD_UGEL,	    
                    cPadrSiagReiEDAD_31_03 
                    )   " . $iPadrId . " SELECT LAST_INSERT_ID() AS iPadrSiagReiId");
                    $respaldo = $respaldo - 1000;
                }

                if ($tabla[0]->iPadrSiagReiId > 0) {
                    $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
                    $codeResponse = 200;
                } else {
                    $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                    $codeResponse = 500;
                }
            }
        }

        return response()->json($response, $codeResponse);
    }

    public function import_siagie_con(Request $request)
    {
        $cPadrTabla = DB::table('PADRON as p')
            ->select('p.cPadrTabla', 'p.cPadrRuta')
            ->where('iPadrId', $request->iPadrId)
            ->get();

        $iPadrSiagConId = DB::table("PADRON_" . $cPadrTabla[0]->cPadrTabla)
            ->where('iPadrId', $request->iPadrId)
            ->count();


        if ($iPadrSiagConId > 0) {
            //return 'YA TIENE REGISTROS';
            $response = ['validated' => false, 'mensaje' => 'YA TIENE REGISTROS.'];
            $codeResponse = 200;
        } else {
            //return 'NO';

            $data = Excel::toArray('', public_path('documentos/') . $cPadrTabla[0]->cPadrRuta);

            if (count($data) > 0) {

                $total = count($data[0]) - 1;
                $respaldo = count($data[0]) - 1;
                $k = 0;

                for ($j = 1; $j <= $total; $j = $j + 1000) {
                    //sleep(5);
                    if ($respaldo < 1000) {
                        $limite = $respaldo;
                    } else {
                        $limite = 1000;
                    }
                    set_time_limit(90);
                    ini_set('memory_limit', '1024M');
                    $iPadrId = '';
                    for ($i = 1; $i <= $limite; $i++) {
                        $k = $k + 1;
                        if ($i == 1) {
                            $sel = ' SELECT';
                        } else {
                            $sel = ' UNION ALL SELECT ';
                        }

                        $cPadrSiagConD_DOCUMENTO		= $data[0][$k][0] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][0]))) : '-';
                        $cPadrSiagConC_DNI              = $data[0][$k][1] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][1]))) : '-';
                        $cPadrSiagConD_VALIDO           = $data[0][$k][2] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][2]))) : '-';
                        $cPadrSiagConC_ESTUDIANTE       = $data[0][$k][3] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][3]))) : '-';
                        $cPadrSiagConD_APE_PATE         = $data[0][$k][4] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][4]))) : '-';
                        $cPadrSiagConD_APE_MATE         = $data[0][$k][5] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][5]))) : '-';
                        $cPadrSiagConD_NOMBRES          = $data[0][$k][6] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][6]))) : '-';
                        $cPadrSiagConF_NACI             = $data[0][$k][7] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][7]))) : '-';
                        $cPadrSiagConD_SEXO             = $data[0][$k][8] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][8]))) : '-';
                        $cPadrSiagConD_GRADO            = $data[0][$k][9] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][9]))) : '-';
                        $cPadrSiagConD_SECCION          = $data[0][$k][10] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][10]))) : '-';
                        $cPadrSiagConD_MATRICULA        = $data[0][$k][11] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][11]))) : '-';
                        $cPadrSiagConD_SITUACION        = $data[0][$k][12] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][12]))) : '-';
                        $cPadrSiagConD_DIRECCION        = $data[0][$k][13] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][13]))) : '-';
                        $cPadrSiagConD_CEN_POBLADO      = $data[0][$k][14] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][14]))) : '-';
                        $cPadrSiagConD_DIST             = $data[0][$k][15] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][15]))) : '-';
                        $cPadrSiagConD_PROV             = $data[0][$k][16] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][16]))) : '-';
                        $cPadrSiagConD_DEPA             = $data[0][$k][17] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][17]))) : '-';
                        $cPadrSiagConC_MODULAR          = $data[0][$k][18] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][18]))) : '-';
                        $cPadrSiagConC_LOCAL            = $data[0][$k][19] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][19]))) : '-';
                        $cPadrSiagConD_IIEE             = $data[0][$k][20] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][20]))) : '-';
                        $cPadrSiagConC_ANEXO            = $data[0][$k][21] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][21]))) : '-';
                        $cPadrSiagConD_NIVE_MODA        = $data[0][$k][22] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][22]))) : '-';
                        $cPadrSiagConD_GESTION          = $data[0][$k][23] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][23]))) : '-';
                        $cPadrSiagConD_PAIS             = $data[0][$k][24] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][24]))) : '-';
                        $cPadrSiagConD_UGEL				= $data[0][$k][25] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][25]))) : '-';
                        $cPadrSiagConCOD_UBI			= $data[0][$k][26] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][26]))) : '-';
                        $cPadrSiagConCOD_UGEL	        = $data[0][$k][27] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][27]))) : '-';
                        $cPadrSiagConEDAD_31_03         = $data[0][$k][28] ? preg_replace('([^A-Za-z0-9\s])', '', iconv("utf-8", "ascii//TRANSLIT", trim($data[0][$k][28]))) : '-';

                        $iPadrId = $iPadrId . $sel . "      
                     " . $request->iPadrId . " , 
                     '" . $cPadrSiagConD_DOCUMENTO . "' ,	
                     '" . $cPadrSiagConC_DNI . "' ,          
                     '" . $cPadrSiagConD_VALIDO . "' ,       
                     '" . $cPadrSiagConC_ESTUDIANTE . "' ,   
                     '" . $cPadrSiagConD_APE_PATE . "' ,     
                     '" . $cPadrSiagConD_APE_MATE . "' ,     
                     '" . $cPadrSiagConD_NOMBRES . "' ,      
                     '" . $cPadrSiagConF_NACI . "' ,         
                     '" . $cPadrSiagConD_SEXO . "' ,         
                     '" . $cPadrSiagConD_GRADO . "' ,        
                     '" . $cPadrSiagConD_SECCION . "' ,      
                     '" . $cPadrSiagConD_MATRICULA . "' ,    
                     '" . $cPadrSiagConD_SITUACION . "' ,    
                     '" . $cPadrSiagConD_DIRECCION . "' ,    
                     '" . $cPadrSiagConD_CEN_POBLADO . "' ,  
                     '" . $cPadrSiagConD_DIST . "' ,         
                     '" . $cPadrSiagConD_PROV . "' ,         
                     '" . $cPadrSiagConD_DEPA . "' ,         
                     '" . $cPadrSiagConC_MODULAR . "' ,      
                     '" . $cPadrSiagConC_LOCAL . "' ,        
                     '" . $cPadrSiagConD_IIEE . "' ,         
                     '" . $cPadrSiagConC_ANEXO . "' ,        
                     '" . $cPadrSiagConD_NIVE_MODA . "' ,    
                     '" . $cPadrSiagConD_GESTION . "' ,      
                     '" . $cPadrSiagConD_PAIS . "' ,         
                     '" . $cPadrSiagConD_UGEL . "' ,			
                     '" . $cPadrSiagConCOD_UBI . "' ,		
                     '" . $cPadrSiagConCOD_UGEL . "' ,	    
                     '" . $cPadrSiagConEDAD_31_03 . "'  "; 
                    }
                    $tabla = DB::select(" INSERT INTO PADRON_" . $cPadrTabla[0]->cPadrTabla . " (
                    iPadrId,
                    cPadrSiagConD_DOCUMENTO,	
                    cPadrSiagConC_DNI,          
                    cPadrSiagConD_VALIDO,       
                    cPadrSiagConC_ESTUDIANTE,   
                    cPadrSiagConD_APE_PATE,     
                    cPadrSiagConD_APE_MATE,     
                    cPadrSiagConD_NOMBRES,      
                    cPadrSiagConF_NACI,         
                    cPadrSiagConD_SEXO,         
                    cPadrSiagConD_GRADO,        
                    cPadrSiagConD_SECCION,      
                    cPadrSiagConD_MATRICULA,    
                    cPadrSiagConD_SITUACION,    
                    cPadrSiagConD_DIRECCION,    
                    cPadrSiagConD_CEN_POBLADO,  
                    cPadrSiagConD_DIST,         
                    cPadrSiagConD_PROV,         
                    cPadrSiagConD_DEPA,         
                    cPadrSiagConC_MODULAR,      
                    cPadrSiagConC_LOCAL,        
                    cPadrSiagConD_IIEE,         
                    cPadrSiagConC_ANEXO,        
                    cPadrSiagConD_NIVE_MODA,    
                    cPadrSiagConD_GESTION,      
                    cPadrSiagConD_PAIS,         
                    cPadrSiagConD_UGEL,			
                    cPadrSiagConCOD_UBI,		
                    cPadrSiagConCOD_UGEL,	    
                    cPadrSiagConEDAD_31_03 
                    )   " . $iPadrId . " SELECT LAST_INSERT_ID() AS iPadrSiagConId");
                    $respaldo = $respaldo - 1000;
                }

                if ($tabla[0]->iPadrSiagConId > 0) {
                    $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
                    $codeResponse = 200;
                } else {
                    $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                    $codeResponse = 500;
                }
            }
        }

        return response()->json($response, $codeResponse);
    }
}