<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class InstitucionEducativaController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );
        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->InstEducId                 ?? null,
            $request->iMiniId                     ?? null,
            $request->iDireId                     ?? null,
            $request->iUgelId                     ?? null,
            $request->iModaNiveId                 ?? null,
            $request->iFormEducId                 ?? null,
            $request->iCaraEducId                 ?? null,
            $request->iGeneEducId                 ?? null,
            $request->iGestEducId                  ?? null,
            $request->iDepeGestEducId             ?? null,
            $request->iAreaGeogEducId             ?? null,
            $request->iTipoProgEducId              ?? null,
            $request->iTurnEducId                 ?? null,
            $request->iEstaEducId                 ?? null,
            $request->iUbigeoId                     ?? null,
            $request->iPersEducId                 ?? null,
            $request->cInstEducCodigoModular         ?? null,
            $request->iInstEducAnexo                 ?? null,
            $request->iInstEducCodigoLocal         ?? null,
            $request->cInstEducNombre             ?? null,
            $request->cInstEducDescripcion         ?? null,
            $request->cInstEducRuc                 ?? null,
            $request->cInstEducTeléfono             ?? null,
            $request->cInstEducCorreo                ?? null,
            $request->cInstEducWeb                 ?? null,
            $request->cInstEducDireccion             ?? null,
            $request->cInstEducModaNiveCode         ?? null,
            $request->cInstEducCaraEducCode         ?? null,
            $request->cInstEducUbigeo             ?? null,
            $request->cInstEducLatitud             ?? null,
            $request->cInstEducLongitud             ?? null,
            $request->cInstEducTurnEducCode         ?? null,
            $request->cInstEducUgelCode             ?? null,
            $request->iInstEducTotalDocentes         ?? null,
            $request->iInstEducTotalEstudiantes     ?? null,
            $request->iInstEducTotalGrados         ?? null,
            $request->iInstEducTotalSeccion         ?? null, //39    

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId //46

        ];

        try {
            $data = DB::select('CALL Sp_DGI_CRUD_INSTITUCION_EDUCATIVA
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            $response = ['validated' => true, 'mensaje' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '',

            $request->InstEducId                 ?? null,
            $request->iMiniId                     ?? null,
            $request->iDireId                     ?? null,
            $request->iUgelId                     ?? null,
            $request->iModaNiveId                 ?? null,
            $request->iFormEducId                 ?? null,
            $request->iCaraEducId                 ?? null,
            $request->iGeneEducId                 ?? null,
            $request->iGestEducId                  ?? null,
            $request->iDepeGestEducId             ?? null,
            $request->iAreaGeogEducId             ?? null,
            $request->iTipoProgEducId              ?? null,
            $request->iTurnEducId                 ?? null,
            $request->iEstaEducId                 ?? null,
            $request->iUbigeoId                     ?? null,
            $request->iPersEducId                 ?? null,
            $request->cInstEducCodigoModular         ?? null,
            $request->iInstEducAnexo                 ?? null,
            $request->iInstEducCodigoLocal         ?? null,
            $request->cInstEducNombre             ?? null,
            $request->cInstEducDescripcion         ?? null,
            $request->cInstEducRuc                 ?? null,
            $request->cInstEducTeléfono             ?? null,
            $request->cInstEducCorreo                ?? null,
            $request->cInstEducWeb                 ?? null,
            $request->cInstEducDireccion             ?? null,
            $request->cInstEducModaNiveCode         ?? null,
            $request->cInstEducCaraEducCode         ?? null,
            $request->cInstEducUbigeo             ?? null,
            $request->cInstEducLatitud             ?? null,
            $request->cInstEducLongitud             ?? null,
            $request->cInstEducTurnEducCode         ?? null,
            $request->cInstEducUgelCode             ?? null,
            $request->iInstEducTotalDocentes         ?? null,
            $request->iInstEducTotalEstudiantes     ?? null,
            $request->iInstEducTotalGrados         ?? null,
            $request->iInstEducTotalSeccion         ?? null, //39            

            $request->iEstado       ?? 1,
            $request->bHabilitado   ?? 1,

            $request->cEquipoSis    ?? 'equipo',
            $request->ip(),
            $request->cOpenUsr      ?? 'N',
            $request->cMacNicSis    ?? 'mac',

            $request->iCredId

        ];

        try {

            $data = DB::select('CALL Sp_DGI_CRUD_INSTITUCION_EDUCATIVA
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);

            if ($data[0]->iInstEducId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                $codeResponse = 200;
            } else {
                $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }
}
