<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;



class DetalleIndicadorController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [

            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iPadrIndiDetaId            ?? NULL,
            $request->iPadrIndiId                ?? NULL,
            $request->iInstEducId                ?? NULL,

            $request->iPadrIndiDetaIndicador1    ?? NULL,
            $request->iPadrIndiDetaIndicador2    ?? NULL,
            $request->iPadrIndiDetaIndicador3    ?? NULL,
            $request->iPadrIndiDetaIndicador4    ?? NULL,
            $request->iPadrIndiDetaIndicador5    ?? NULL,
            $request->iPadrIndiDetaIndicador6    ?? NULL,
            $request->iPadrIndiDetaIndicador7    ?? NULL,
            $request->iPadrIndiDetaIndicador8    ?? NULL,
            $request->iPadrIndiDetaIndicador9    ?? NULL,
            $request->iPadrIndiDetaIndicador10   ?? NULL,
            $request->iPadrIndiDetaIndicador11   ?? NULL,
            $request->iPadrIndiDetaIndicador12   ?? NULL,
            $request->iPadrIndiDetaIndicador13   ?? NULL,
            $request->iPadrIndiDetaIndicador14   ?? NULL,
            $request->iPadrIndiDetaIndicador15   ?? NULL,
            $request->iPadrIndiDetaIndicador16   ?? NULL,
            $request->iPadrIndiDetaIndicador17   ?? NULL,
            $request->iPadrIndiDetaIndicador18   ?? NULL,
            $request->iPadrIndiDetaIndicador19   ?? NULL,
            $request->iPadrIndiDetaIndicador20   ?? NULL,

            $request->iEstado ?? 1,
            $request->bHabilitado ?? true, 

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',//30
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('CALL Sp_DGI_CRUD_PADRON_INDICADOR_DETALLE
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'message' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '',

            $request->iPadrIndiDetaId            ?? NULL,
            $request->iPadrIndiId                ?? NULL,
            $request->iInstEducId                ?? NULL,

            $request->iPadrIndiDetaIndicador1    ?? NULL,
            $request->iPadrIndiDetaIndicador2    ?? NULL,
            $request->iPadrIndiDetaIndicador3    ?? NULL,
            $request->iPadrIndiDetaIndicador4    ?? NULL,
            $request->iPadrIndiDetaIndicador5    ?? NULL,
            $request->iPadrIndiDetaIndicador6    ?? NULL,
            $request->iPadrIndiDetaIndicador7    ?? NULL,
            $request->iPadrIndiDetaIndicador8    ?? NULL,
            $request->iPadrIndiDetaIndicador9    ?? NULL,
            $request->iPadrIndiDetaIndicador10   ?? NULL,
            $request->iPadrIndiDetaIndicador11   ?? NULL,
            $request->iPadrIndiDetaIndicador12   ?? NULL,
            $request->iPadrIndiDetaIndicador13   ?? NULL,
            $request->iPadrIndiDetaIndicador14   ?? NULL,
            $request->iPadrIndiDetaIndicador15   ?? NULL,
            $request->iPadrIndiDetaIndicador16   ?? NULL,
            $request->iPadrIndiDetaIndicador17   ?? NULL,
            $request->iPadrIndiDetaIndicador18   ?? NULL,
            $request->iPadrIndiDetaIndicador19   ?? NULL,
            $request->iPadrIndiDetaIndicador20   ?? NULL,

            $request->iEstado       ?? 1,
            $request->bHabilitado   ?? 1,

            $request->cEquipoSis    ?? 'equipo',
            $request->ip(),
            $request->cOpenUsr      ?? 'N',
            $request->cMacNicSis    ?? 'mac',

            $request->iCredId //31

        ];

        try {

            $data = DB::select('CALL Sp_DGI_CRUD_PADRON_INDICADOR_DETALLE
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            // return $data;
            if ($data[0]->iPadrIndiDetaId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                $codeResponse = 200;
            } else {
                $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }
}
