<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ConfiguracionVacanteController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iConfVacaId		?? null,
            $request->iAniEducdId		?? null,
            $request->dtFechaInicio     ?? null,
            $request->dtFechaFin        ??  null,
            
            

        ];

        try {
            $data = DB::select('CALL Sp_DGI_CRUD_CONFIGURACION_VACANTE
            (?,?,?,?,?,?)', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iConfVacaId		?? null,
            $request->iAniEducdId		?? null,
            $request->dtFechaInicio     ?? null,
            $request->dtFechaFin        ??  null,
            
            

        ];

        try {

            $data = DB::select('CALL Sp_DGI_CRUD_CONFIGURACION_VACANTE
            (?,?,?,?,?,?)', $parametros);

            if ($data[0]->iConfVacaId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                $codeResponse = 200;
            } else {
                $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

   
}
