<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AnioEducativoController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iAniEducdId			?? null,
            $request->iAniEducdNombre		?? null,
            $request->cAniEducdDescripcion  ?? null,
            
            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('call Sp_DGI_CRUD_ANIO_EDUCATIVO(?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => ($e->errorInfo[2]), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function search($data)
    {

        $parametros = [
            $data['opcion'] ?? NULL,
            $data['valorBusqueda'] ?? '-',

            $data['iAniEducdId'] ?? NULL,			
            $data['iAniEducdNombre'] ?? NULL,		
            $data['cAniEducdDescripcion'] ?? NULL,  

            $data['iEstado'] ?? 1,
            $data['bHabilitado'] ?? true,

            $data['cEquipoSis'] ?? 'equipo',
            $data['cOpenUsr'] ?? 'N',
            $data['cMacNicSis'] ?? 'mac',
            '-',

            $data['iCredId'] ?? NULL

        ];


        $data = DB::select('call Sp_DGI_CRUD_ANIO_EDUCATIVO(?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);


        return $data;
    }
}
