<?php

namespace App\Http\Controllers\GRL;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\GRL\PersonasController;
use App\Http\Controllers\GRL\PersonaTipoContactoController;

class EmpresasController extends Controller
{
    public function store(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );
        if ($request->opcion == 'GUARDAR') {
            $persona = new PersonasController();
            $response_persona = $persona->store($request);

            $request->iPersId = $response_persona['data'][0]->iPersId;

            $persona_tipo_contacto = new PersonaTipoContactoController();
            $response_persona_tipo_contacto = $persona_tipo_contacto->store($request);
        }

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iEmprId               ?? NULL,
            $request->iPersId               ?? NULL,
            $request->iSectId               ?? NULL,
            $request->iEntiId               ?? NULL,
            $request->cEmprNombre           ?? NULL,
            $request->cEmprDescripcion      ?? NULL,
            $request->cEmprLogo             ?? NULL,
            $request->dEmprFundacion        ?? NULL,
            $request->cEmprHistoria         ?? NULL,
            $request->cEmprServicios        ?? NULL,
            $request->cEmprExperiencia      ?? NULL,
            $request->dEmprRegistro         ?? NULL,
            $request->dEmprAprobacion       ?? NULL,
            $request->cEmprNombreContacto   ?? NULL,
            $request->cEmprPuestoContacto   ?? NULL,
            $request->cEmprLinkFb           ?? NULL,
            $request->cEmprLinkWeb          ?? NULL,


            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId


        ];
        
        try {
            $data = DB::select('exec GRL.Sp_GRL_CRUD_EMPRESAS
            ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);

            if ($data[0]->iEmprId > 0) {

                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
                $codeResponse = 200;
            } else {
                $response = ['validated' => true, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {

            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'exception' => $e];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }
}
