<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TipoPadronController extends Controller
{
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',
            $request->valorBusqueda1 ?? '-',
            
            $request->iTipoPadrId			?? null,
            $request->cTipoPadrNombre		?? null,
            $request->cTipoPadrDescripcion  ?? null,
            $request->cTipoPadrAbreviatura		?? null,
            
            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('CALL Sp_DGI_CRUD_TIPO_PADRON(?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function search($data)
    {

        $parametros = [
            $data['opcion'] ?? NULL,
            $data['valorBusqueda'] ?? '-',
            $data['valorBusqueda1'] ?? '-',

            $data['iTipoPadrId'] ?? NULL,			
            $data['cTipoPadrNombre'] ?? NULL,		
            $data['cTipoPadrDescripcion'] ?? NULL,  
            $data['cTipoPadrAbreviatura'] ?? NULL,		

            $data['iEstado'] ?? 1,
            $data['bHabilitado'] ?? true,

            $data['cEquipoSis'] ?? 'equipo',
            $data['cOpenUsr'] ?? 'N',
            $data['cMacNicSis'] ?? 'mac',
            '-',

            $data['iCredId'] ?? NULL

        ];


        $data = DB::select('CALL Sp_DGI_CRUD_TIPO_PADRON(?,?,?,?,?,?,?,?,?,?,?,?,?,?)', $parametros);


        return $data;
    }
}
