<?php

namespace App\Http\Controllers\DGI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class PadronNominalController extends Controller
{


    
    public function list(Request $request)
    {

        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '-',

            $request->iPadrNomiId			?? NULL,	
            $request->iPadrId				?? NULL,	
            $request->cPadrNomiTIP_DOC		?? NULL,
            $request->cPadrNomiCOD_PAD      ?? NULL, 
            $request->cPadrNomiCOD_CNV      ?? NULL, 
            $request->cPadrNomiCOD_CUI      ?? NULL, 
            $request->cPadrNomiMEN_NRO_DNI  ?? NULL, 
            $request->cPadrNomiMEN_EST_TRA  ?? NULL, 
            $request->cPadrNomiFEC_TRA      ?? NULL, 
            $request->cPadrNomiMEN_APE_PAT  ?? NULL, 
            $request->cPadrNomiMEN_APE_MAT  ?? NULL, 
            $request->cPadrNomiMEN_NOM      ?? NULL, 
            $request->cPadrNomiMEN_COD_SEX  ?? NULL, 
            $request->cPadrNomiMEN_FEC_NAC  ?? NULL, 
            $request->cPadrNomiMEN_EDA_AMD  ?? NULL, 
            $request->cPadrNomiEJE_VIA      ?? NULL, 
            $request->cPadrNomiDIR_DES      ?? NULL, 
            $request->cPadrNomiREF_DIR      ?? NULL, 
            $request->cPadrNomiCOD_UBI      ?? NULL, 
            $request->cPadrNomiNOM_DEP      ?? NULL, 
            $request->cPadrNomiNOM_PRO      ?? NULL, 
            $request->cPadrNomiNOM_DIS      ?? NULL, 
            $request->cPadrNomiCOD_CEN_POB  ?? NULL, 
            $request->cPadrNomiNOM_CEN_POB  ?? NULL, 
            $request->cPadrNomiCAR_CEN_POB  ?? NULL, 
            $request->cPadrNomiVIS_MEN      ?? NULL, 
            $request->cPadrNomiVIS_ENC      ?? NULL, 
            $request->cPadrNomiVIS_FEC      ?? NULL, 
            $request->cPadrNomiFUE_INS      ?? NULL, 
            $request->cPadrNomiFUE_FEC      ?? NULL, 
            $request->cPadrNomiCOD_EESS_NAC ?? NULL, 
            $request->cPadrNomiNOM_EESS_NAC ?? NULL, 
            $request->cPadrNomiCOD_EESS     ?? NULL, 
            $request->cPadrNomiNOM_EESS     ?? NULL, 
            $request->cPadrNomiFRE_ATE      ?? NULL, 
            $request->cPadrNomiCOD_EESS_ADS ?? NULL, 
            $request->cPadrNomiNOM_EESS_ADS ?? NULL, 
            $request->cPadrNomiTIP_SEG      ?? NULL, 
            $request->cPadrNomiTIP_PRO_SOC  ?? NULL, 
            $request->cPadrNomiCOD_IIEE     ?? NULL, 
            $request->cPadrNomiNOM_IIEE     ?? NULL, 
            $request->cPadrNomiFAM_TIP      ?? NULL, 
            $request->cPadrNomiFAM_TIP_DOC  ?? NULL, 
            $request->cPadrNomiFAM_NRO_DOC  ?? NULL, 
            $request->cPadrNomiFAM_APE_PAT  ?? NULL, 
            $request->cPadrNomiFAM_APE_MAT  ?? NULL, 
            $request->cPadrNomiFAM_NOM      ?? NULL, 
            $request->cPadrNomiFAM_CEL      ?? NULL, 
            $request->cPadrNomiFAM_EMA      ?? NULL, 
            $request->cPadrNomiFAM_GRA_INS  ?? NULL, 
            $request->cPadrNomiFAM_LEN_HAB  ?? NULL, 
            $request->cPadrNomiJEF_TIP      ?? NULL, 
            $request->cPadrNomiJEF_TIP_DOC  ?? NULL, 
            $request->cPadrNomiJEF_NRO_DOC  ?? NULL, 
            $request->cPadrNomiJEF_APE_PAT  ?? NULL, 
            $request->cPadrNomiJEF_APE_MAT  ?? NULL, 
            $request->cPadrNomiJEF_NOM      ?? NULL, 
            $request->cPadrNomiREG_EST      ?? NULL, 
            $request->cPadrNomiREG_FEC_CRE  ?? NULL, 
            $request->cPadrNomiREG_USU      ?? NULL, 
            $request->cPadrNomiREG_FEC_MOD  ?? NULL, 
            $request->cPadrNomiREG_USU_MOD  ?? NULL, 
            $request->cPadrNomiREG_ENT      ?? NULL, 
            $request->cPadrNomiREG_TIP      ?? NULL, 
            $request->cPadrNomiCIE_EDA		?? NULL,   
            
            $request->iEstado ?? 1,
            $request->bHabilitado ?? true,

            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId

        ];

        try {
            $data = DB::select('exec DGI.Sp_DGI_CRUD_PADRON_NOMINAL
            ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);
            $response = ['validated' => true, 'message' => 'se obtuvo la información', 'data' => $data];
            $codeResponse = 200;
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function store(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->opcion,
            $request->valorBusqueda ?? '',

            $request->iPadrNomiId			?? NULL,	
            $request->iPadrId				?? NULL,	
            $request->cPadrNomiTIP_DOC		?? NULL,
            $request->cPadrNomiCOD_PAD      ?? NULL, 
            $request->cPadrNomiCOD_CNV      ?? NULL, 
            $request->cPadrNomiCOD_CUI      ?? NULL, 
            $request->cPadrNomiMEN_NRO_DNI  ?? NULL, 
            $request->cPadrNomiMEN_EST_TRA  ?? NULL, 
            $request->cPadrNomiFEC_TRA      ?? NULL, 
            $request->cPadrNomiMEN_APE_PAT  ?? NULL, 
            $request->cPadrNomiMEN_APE_MAT  ?? NULL, 
            $request->cPadrNomiMEN_NOM      ?? NULL, 
            $request->cPadrNomiMEN_COD_SEX  ?? NULL, 
            $request->cPadrNomiMEN_FEC_NAC  ?? NULL, 
            $request->cPadrNomiMEN_EDA_AMD  ?? NULL, 
            $request->cPadrNomiEJE_VIA      ?? NULL, 
            $request->cPadrNomiDIR_DES      ?? NULL, 
            $request->cPadrNomiREF_DIR      ?? NULL, 
            $request->cPadrNomiCOD_UBI      ?? NULL, 
            $request->cPadrNomiNOM_DEP      ?? NULL, 
            $request->cPadrNomiNOM_PRO      ?? NULL, 
            $request->cPadrNomiNOM_DIS      ?? NULL, 
            $request->cPadrNomiCOD_CEN_POB  ?? NULL, 
            $request->cPadrNomiNOM_CEN_POB  ?? NULL, 
            $request->cPadrNomiCAR_CEN_POB  ?? NULL, 
            $request->cPadrNomiVIS_MEN      ?? NULL, 
            $request->cPadrNomiVIS_ENC      ?? NULL, 
            $request->cPadrNomiVIS_FEC      ?? NULL, 
            $request->cPadrNomiFUE_INS      ?? NULL, 
            $request->cPadrNomiFUE_FEC      ?? NULL, 
            $request->cPadrNomiCOD_EESS_NAC ?? NULL, 
            $request->cPadrNomiNOM_EESS_NAC ?? NULL, 
            $request->cPadrNomiCOD_EESS     ?? NULL, 
            $request->cPadrNomiNOM_EESS     ?? NULL, 
            $request->cPadrNomiFRE_ATE      ?? NULL, 
            $request->cPadrNomiCOD_EESS_ADS ?? NULL, 
            $request->cPadrNomiNOM_EESS_ADS ?? NULL, 
            $request->cPadrNomiTIP_SEG      ?? NULL, 
            $request->cPadrNomiTIP_PRO_SOC  ?? NULL, 
            $request->cPadrNomiCOD_IIEE     ?? NULL, 
            $request->cPadrNomiNOM_IIEE     ?? NULL, 
            $request->cPadrNomiFAM_TIP      ?? NULL, 
            $request->cPadrNomiFAM_TIP_DOC  ?? NULL, 
            $request->cPadrNomiFAM_NRO_DOC  ?? NULL, 
            $request->cPadrNomiFAM_APE_PAT  ?? NULL, 
            $request->cPadrNomiFAM_APE_MAT  ?? NULL, 
            $request->cPadrNomiFAM_NOM      ?? NULL, 
            $request->cPadrNomiFAM_CEL      ?? NULL, 
            $request->cPadrNomiFAM_EMA      ?? NULL, 
            $request->cPadrNomiFAM_GRA_INS  ?? NULL, 
            $request->cPadrNomiFAM_LEN_HAB  ?? NULL, 
            $request->cPadrNomiJEF_TIP      ?? NULL, 
            $request->cPadrNomiJEF_TIP_DOC  ?? NULL, 
            $request->cPadrNomiJEF_NRO_DOC  ?? NULL, 
            $request->cPadrNomiJEF_APE_PAT  ?? NULL, 
            $request->cPadrNomiJEF_APE_MAT  ?? NULL, 
            $request->cPadrNomiJEF_NOM      ?? NULL, 
            $request->cPadrNomiREG_EST      ?? NULL, 
            $request->cPadrNomiREG_FEC_CRE  ?? NULL, 
            $request->cPadrNomiREG_USU      ?? NULL, 
            $request->cPadrNomiREG_FEC_MOD  ?? NULL, 
            $request->cPadrNomiREG_USU_MOD  ?? NULL, 
            $request->cPadrNomiREG_ENT      ?? NULL, 
            $request->cPadrNomiREG_TIP      ?? NULL, 
            $request->cPadrNomiCIE_EDA		?? NULL,  //67

            $request->iEstado       ?? 1,
            $request->bHabilitado   ?? 1,

            $request->cEquipoSis    ?? 'equipo',//70
            $request->ip(),
            $request->cOpenUsr      ?? 'N',
            $request->cMacNicSis    ?? 'mac',

            $request->iCredId//74
        ];

        try {

            $data = DB::select('exec DGI.Sp_DGI_CRUD_PADRON_NOMINAL
            ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?', $parametros);
            
            if ($data[0]->iPadrNomiId > 0) {
                $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.', 'data' => $data];
                $codeResponse = 200;
            } else {
                $response = ['validated' => false, 'mensaje' => 'No se ha podido guardar la información.'];
                $codeResponse = 500;
            }
        } catch (\Exception $e) {
            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), $e->getMessage(), 'data' => []];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }

    public function import(Request $request)
    {
        $this->validate(
            $request,
            [
                'opcion' => 'required',
            ],
            [
                'opcion.required' => 'Hubo un problema al obtener la acción',
            ]
        );

        $parametros = [
            $request->cEquipoSis ?? 'equipo',
            $request->cOpenUsr ?? 'N',
            $request->cMacNicSis ?? 'mac',
            $request->ip(),

            $request->iCredId,

            json_encode($request->json_padron_nominal)
        ];

        try {
            $data = DB::select('exec DGI.Sp_DGI_IMPORT_PADRON_NOMINAL ?,?,?,?,?,?', $parametros);

            $response = ['validated' => true, 'mensaje' => 'Se guardó la información exitosamente.'];
            $codeResponse = 200;
        } catch (\Exception $e) {

            $response = ['validated' => false, 'mensaje' => substr($e->errorInfo[2] ?? '', 54), 'exception' => $e];
            $codeResponse = 500;
        }

        return response()->json($response, $codeResponse);
    }
}
